% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pretree.R
\name{WtoL_multi.tree}
\alias{WtoL_multi.tree}
\title{Wide-to-long, multiple trees}
\usage{
WtoL_multi.tree(
  data,
  cmx_list,
  id.col,
  resp.col_list,
  covar.col = NULL,
  time.col = NULL
)
}
\arguments{
\item{data}{a wide-format (person-by-item) data set}

\item{cmx_list}{a list including all tree structures}

\item{id.col}{the ID column}

\item{resp.col_list}{a list of vectors, with a length matching the length of \code{cmx_list}; 
each element of such a vector points to an item (response variable) using the corresponding
mapping matrix}

\item{covar.col}{columns containing covariates}

\item{time.col}{the time column when there are repeated (longitudinal) data}
}
\description{
Recode a wide format data frame to a long format IRTRees data frame
in the case when items may have different tree structures
}
\details{
Many examples of mapping matrices are given in the vignette. Columns may be specified 
by numeric index or by name. Response categories must be coded with consecutive integers 
starting from 1, not 0. Missing data should be properly represented as NA.
}
