% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processAssay.R
\docType{methods}
\name{processAssay}
\alias{processAssay}
\alias{processAssay,ISA,assayTab,character-method}
\alias{processAssay,ISA,assayTab-method}
\alias{processAssay,ISA,msAssayTab,character-method}
\alias{processAssay,ISA,msAssayTab-method}
\alias{processAssay,ISA,microarrayAssayTab,character-method}
\title{Process assay tab data}
\usage{
processAssay(isaObject, aTabObject, type = c("raw", "derived"))

\S4method{processAssay}{ISA,assayTab,character}(isaObject, aTabObject, type = c("raw", "derived"))

\S4method{processAssay}{ISA,msAssayTab,character}(isaObject, aTabObject, type = c("raw", "derived"))

\S4method{processAssay}{ISA,microarrayAssayTab,character}(isaObject, aTabObject, type = c("raw", "derived"))
}
\arguments{
\item{isaObject}{An object of the \linkS4class{ISA}.}

\item{aTabObject}{An object of the \linkS4class{microarrayAssayTab}.}

\item{type}{A character string indicating which data files should be
processed, either "raw" for raw data files, or "derived" for derived data
files. The file names are taken from the corresponding column in the
\code{aTabObject}.}
}
\description{
Process data from assay tab files

Process data from assay tab files with technology type mass spectrometry
(ms). Processing those files requires the xcms package to be installed.

Process data from assay tab files with technology type DNA microarray
(ms). Processing those files requires the Biobase and affy packages to be
installed.
}
\examples{
### Atwell data.

## Read example Atwell data set.
isaObject1 <- readISATab(path = file.path(system.file("extdata/Atwell",
                                          package = "isatabr")))

## Get assay tabs for isaObject1.
aTabObjects <- getAssayTabs(isaObject1)

## Process assay data.
isaDat <- processAssay(isaObject = isaObject1,
                      aTabObject = aTabObjects$s_study1.txt$a_study1.txt,
                       type = "derived")

## Display first rows and columns.
head(isaDat[, 1:10])

\donttest{
### faahKO data. - This requires the xcms package to be installed.
## Read ISA-Tab files for faahKO.
if (requireNamespace("xcms")) {
  isaObject3 <- readISATab(path = file.path(system.file("extdata/faahKO",
                                            package = "isatabr")))

  ## Get assay tabs for isaObject3.
  aTabObjects3 <- getAssayTabs(isaObject3)

  ## Process assay data.
  isaDat3 <-
    processAssay(isaObject = isaObject3,
                 aTabObject = aTabObjects3$s_Proteomic_profiling_of_yeast.txt$a_metabolite.txt,
                 type = "raw")

  ## Display output.
  isaDat3
  }
}

}
