% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3methods_islasso.path.R
\name{summary.islasso.path}
\alias{summary.islasso.path}
\alias{print.summary.islasso.path}
\title{Summarize islasso.path Model at Specific Lambda}
\usage{
\method{summary}{islasso.path}(object, pval = 1, use.t = FALSE, lambda, ...)
}
\arguments{
\item{object}{A fitted object of class \code{"islasso.path"}.}

\item{pval}{Numeric threshold for displaying coefficients. Only variables with \code{p-value <= pval} are printed.
Unpenalized coefficients (like the intercept) are always shown.}

\item{use.t}{Logical. If \code{TRUE}, p-values are computed using a t-distribution with residual degrees of freedom.}

\item{lambda}{Numeric. Value of the regularization parameter at which the summary should be extracted.}

\item{...}{Currently unused.}
}
\value{
An object of class \code{"summary.islasso.path"} containing filtered estimates and significance metrics.
}
\description{
Extracts coefficient estimates, standard errors and p-values from an \code{\link{islasso.path}} fit at a given regularization level \code{lambda}.
}
\examples{
\dontrun{
# Assuming object `o` is from islasso.path
summary(o, pval = 0.1, lambda = 5)
}

}
\seealso{
\code{\link{islasso.path}}, \code{\link{GoF.islasso.path}}, \code{\link{coef.islasso.path}},
         \code{\link{fitted.islasso.path}}, \code{\link{predict.islasso.path}},
         \code{\link{residuals.islasso.path}}, \code{\link{logLik.islasso.path}},
         \code{\link{deviance.islasso.path}}
}
\author{
Gianluca Sottile \email{gianluca.sottile@unipa.it}
}
