% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluation.R
\name{bscore}
\alias{bscore}
\title{Brier score for forecast probability of threshold exceedance}
\usage{
bscore(predictions, thresholds, y)
}
\arguments{
\item{predictions}{either an object of class \code{idr} (output of
\code{\link{predict.idrfit}}), or a \code{data.frame} of numeric variables.
In the latter case, the CDF is computed using the empirical distribution of
the variables in \code{predictions}.}

\item{thresholds}{numeric vector of thresholds at which the CDF will be
evaluated.}

\item{y}{a numeric vector of obervations of the same length as the number of
predictions, or of length 1. In the latter case, \code{y} will be used for
all predictions.}
}
\value{
A matrix of the Brier scores for the desired thresholds, one column
per threshold.
}
\description{
Computes the Brier score of forecast probabilities for exceeding
given thresholds.
}
\details{
The Brier score for the event of exceeding a given threshold
\emph{z} is defined as \deqn{ (1\{y > z\} - P(y > z))^2 } where \emph{y} is the
observation and \emph{P(y > z)} the forecast probability for exceeding the
threshold \code{z}.
}
\examples{
data("rain")

## Postprocess HRES forecast using data of 3 years

X <- rain[1:(3 * 365), "HRES", drop = FALSE]
y <- rain[1:(3 * 365), "obs"]

fit <- idr(y = y, X = X)

## Compute Brier score for postprocessed probability of precipitation
## forecast using data of the next 2 years (out-of-sample predictions)

data <- rain[(3 * 365 + 1):(5 * 365), "HRES", drop = FALSE]
obs <- rain[(3 * 365 + 1):(5 * 365), "obs"]
predictions <- predict(fit, data = data)
score <- bscore(predictions, thresholds = 0, y = obs)

mean(score)
}
\references{
Gneiting, T. and Raftery, A. E. (2007), 'Strictly proper scoring rules,
prediction, and estimation', Journal of the American Statistical Association
102(477), 359-378
}
\seealso{
\code{\link{predict.idrfit}}, \code{\link{cdf}}
}
