% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isoforest.R
\name{isotree.plot.tree}
\alias{isotree.plot.tree}
\title{Plot Tree from Isolation Forest Model}
\usage{
isotree.plot.tree(
  model,
  output_tree_num = FALSE,
  tree = 1L,
  column_names = NULL,
  column_names_categ = NULL,
  nthreads = model$nthreads,
  width = NULL,
  height = NULL
)
}
\arguments{
\item{model}{An Isolation Forest object as returned by \link{isolation.forest}.}

\item{output_tree_num}{Whether to make the statements / outputs return the terminal node number
instead of the isolation depth. The numeration will start at one.}

\item{tree}{Tree for which to generate SQL statements or other outputs. If passed, will generate
the statements only for that single tree. If passing `NULL`, will
generate statements for all trees in the model.}

\item{column_names}{Column names to use for the \bold{numeric} columns.
If not passed and the model was fit to a `data.frame`, will use the column
names from that `data.frame`, which can be found under `model$metadata$cols_num`.
If not passing it and the model was fit to data in a format other than
`data.frame`, the columns will be named `column_N` in the resulting
SQL statement. Note that the names will be taken verbatim - this function will
not do any checks for e.g. whether they constitute valid SQL or not when exporting to SQL, and will not
escape characters such as double quotation marks when exporting to SQL.}

\item{column_names_categ}{Column names to use for the \bold{categorical} columns.
If not passed, will use the column names from the `data.frame` to which the
model was fit. These can be found under `model$metadata$cols_cat`.}

\item{nthreads}{Number of parallel threads to use.}

\item{width}{Width for the plot, to pass to `DiagrammeR::grViz`.}

\item{height}{Height for the plot, to pass to `DiagrammeR::grViz`.}
}
\value{
An `htmlwidget` object that contains the plot.
}
\description{
Plots a given tree from an isolation forest model.

Requires the `DiagrammeR` library to be installed.

Note that this is just a wrapper over \link{isotree.to.graphviz} + `DiagrammeR::grViz`.
}
\details{
In general, isolation forest trees tend to be rather large, and the contents on the
nodes can be very long when using `ndim>1` - if the idea is to get easily visualizable
trees, one might want to use parameters like `ndim=1`, `sample_size=256`, `max_depth=8`.
}
