% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discovery.R
\name{get_dimension_values}
\alias{get_dimension_values}
\title{Get available values for a dimension}
\usage{
get_dimension_values(dataset, dimension_id)
}
\arguments{
\item{dataset}{An istat_dataset object}

\item{dimension_id}{The ID of the dimension}
}
\value{
A tibble with columns:
\describe{
\item{id}{Value ID/code}
\item{name}{Human-readable name (English)}
}
}
\description{
Retrieves all available values for a specific dimension of a dataset.
}
\examples{
\dontrun{
ds <- istat_dataset("139_176")
get_dimension_values(ds, "TIPO_DATO")
}
}
