% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrieval.R
\name{istat_get}
\alias{istat_get}
\title{Quick data retrieval}
\usage{
istat_get(
  dataflow_id,
  ...,
  start_period = NULL,
  end_period = NULL,
  last_n_observations = NULL
)
}
\arguments{
\item{dataflow_id}{Dataflow ID (e.g., "139_176")}

\item{...}{Named filter arguments (dimension_id = value)}

\item{start_period}{Optional start date}

\item{end_period}{Optional end date}

\item{last_n_observations}{Optional integer to get only the last N observations}
}
\value{
A tibble containing the requested data
}
\description{
A convenience function that combines creating a dataset, setting filters,
and retrieving data in one call.
}
\examples{
\dontrun{
# Quick retrieval with filters
data <- istat_get(
  "139_176",
  FREQ = "M",
  TIPO_DATO = "ISAV",
  PAESE_PARTNER = "WORLD",
  start_period = "2020-01-01"
)
}
}
