% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifilter.R
\name{i_keep}
\alias{i_keep}
\alias{ifilter}
\alias{i_drop}
\alias{ifilterfalse}
\title{Iterator that filters elements not satisfying a predicate function}
\usage{
i_keep(iterable, predicate, ...)

i_drop(iterable, predicate, ...)
}
\arguments{
\item{iterable}{an iterable object.}

\item{predicate}{a function that determines whether an element is
\code{TRUE} or \code{FALSE}. The function is assumed to take only
one argument.}

\item{...}{passed along to \link{iteror} constructor.}
}
\value{
iterator object
}
\description{
\code{i_keep(iterable, predicate)} constructs an iterator that filters
elements from iterable returning only those for which the predicate
is \code{TRUE}.
}
\details{
Originally called 'ifilter' from package
\code{itertools}. Renamed because the order of arguments has changed
to put the iterable in the first argument, the better to be used
with the \verb{|>} operator.
}
\examples{
# Filters out odd numbers and retains only even numbers
is_even <- function(x) {
  x \%\% 2 == 0
}
it <- i_keep(1:10, is_even)
as.list(it)

# Similar idea here but anonymous function is used to retain only odd
# numbers
it2 <- i_drop(1:10, function(x) x \%\% 2 == 0)
nextOr(it2, NA) # 1
nextOr(it2, NA) # 3
nextOr(it2, NA) # 5
nextOr(it2, NA) # 7
nextOr(it2, NA) # 9

is_vowel <- function(x) {
  x \%in\% c('a', 'e', 'i', 'o', 'u')
}
it3 <- i_keep(letters, is_vowel)
as.list(it3)
# Filters out even numbers and retains only odd numbers
is_even <- function(x) {
  x \%\% 2 == 0
}
it <- i_drop(1:10, is_even)
as.list(it)

# Similar idea here but anonymous function is used to filter out odd
# numbers
it2 <- i_drop(1:10, function(x) x \%\% 2 == 1)
as.list(it2)

is_vowel <- function(x) {
  x \%in\% c('a', 'e', 'i', 'o', 'u')
}
it3 <- i_drop(letters, is_vowel)
nextOr(it3, NA) # b
nextOr(it3, NA) # c
nextOr(it3, NA) # d
nextOr(it3, NA) # f
nextOr(it3, NA) # g
# nextOr(it, NA) continues through the rest of the consonants

}
\seealso{
i_drop i_keepwhile i_dropwhile
}
