% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/i_recycle.R
\name{i_recycle}
\alias{i_recycle}
\title{Create a recycling iterator}
\usage{
i_recycle(iterable, times = Inf, ...)
}
\arguments{
\item{iterable}{The iterable to recycle.}

\item{times}{integer.  Number of times to recycle the values .
Default value of \code{Inf} means to recycle indefinitely.}

\item{...}{Further arguments will be passed along to \link{iteror}.}
}
\value{
an \link{iteror} recycling the values from the underlying iterable.
}
\description{
Create an iterator that recycles a specified iterable. On the first
repeat the iterable is buffered into memory until it finishes, then
we repeat the same sequence of values.
}
\details{
Originally from the \code{itertools} package.
}
\examples{

# Recycle over 'a', 'b', and 'c' three times
i <- i_recycle(letters[1:3], 3)
as.character(i)

it <- i_recycle(1:3)
nextOr(it, NA) # 1
nextOr(it, NA) # 2
nextOr(it, NA) # 3
nextOr(it, NA) # 1
nextOr(it, NA) # 2
nextOr(it, NA) # 3
nextOr(it, NA) # 1

it2 <- i_recycle(1:3, times=2)
as.list(it2)

}
