% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rfun_optk.R
\name{optk}
\alias{optk}
\title{The two-step algorithm to calculate the best k value for the improved trimmed Hochberg method to ensure that the maximum type I error rate reaches alpha exactly when rho is arbitrary}
\usage{
optk(alpha, alphavec = c(alpha/2, alpha/2))
}
\arguments{
\item{alpha}{the significance level}

\item{alphavec}{a numeric vector of two values representing the weighted significance levels assigned to the two hypotheses}
}
\value{
the best k value \code{k_opt} and the rho value that makes the type I error rate reaches the maximum value \code{rho_opt}
}
\description{
The two-step algorithm to calculate the best k value for the improved trimmed Hochberg method to ensure that the maximum type I error rate reaches alpha exactly when rho is arbitrary
}
\examples{
optk(alpha = 0.025)
}
\references{
Gou, J., Chang, Y., Li, T., and Zhang, F. (2025). Improved trimmed weighted Hochberg procedures with two endpoints and sample size optimization. Technical Report.
}
\author{
Jiangtao Gou

Fengqing Zhang
}
