% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_vernacularname.R
\name{get_common_name}
\alias{get_common_name}
\title{Retrieve Vernacular Names for a Given Species}
\usage{
get_common_name(splist)
}
\arguments{
\item{splist}{A character vector containing the scientific names of species for which vernacular names are to be retrieved.}
}
\value{
A \code{data.table} or \code{data.frame} with columns:
\describe{
\item{submitted_name}{The scientific name of the species as submitted.}
\item{vernacular_names}{A character string that contains the concatenated vernacular names for each species, separated by " - ".}
}
}
\description{
This function retrieves vernacular (common) names for a given species using IUCN data.
It filters vernacular names based on matching \code{internal_taxon_id} and merges
them with species metadata.
}
\details{
The function retrieves IUCN data for the input species, extracts the corresponding \code{core_id}, filters the vernacular name dataset using the \code{core_id}, and concatenates all unique vernacular names for each species.
}
\examples{
\donttest{
species <- c("Panthera uncia", "Cedrela odorata")
result <- get_common_name(splist = species)
print(result)
}

}
