% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jaccard.test.R
\name{jaccard.test.pairwise}
\alias{jaccard.test.pairwise}
\title{Pair-wise tests for Jaccard/Tanimoto similarity coefficients}
\usage{
jaccard.test.pairwise(
  dat,
  method = "mca",
  verbose = TRUE,
  compute.qvalue = TRUE,
  ...
)
}
\arguments{
\item{dat}{a data matrix}

\item{method}{a method to compute a p-value (\code{"mca"}, \code{"bootstrap"}, \code{"asymptotic"}, or \code{"exact"})}

\item{verbose}{whether to print progress messages}

\item{compute.qvalue}{whether to compute q-values}

\item{...}{optional arguments for specific computational methods}
}
\value{
\code{jaccard.test.pairwise} returns a list of matrices
\item{statistics}{Jaccard/Tanimoto similarity coefficients}
\item{pvalues}{p-values}
\item{qvalues}{q-values}
}
\description{
Given a data matrix, it computes pair-wise Jaccard/Tanimoto similarity coefficients
and p-values among rows (variables). Only for testing due to its use of a for-loop.
}
\seealso{
\link{jaccard.test}
}
