% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jackstrap_ks.R
\name{jackstrap_ks}
\alias{jackstrap_ks}
\title{Jackstrap KS Method: Tool identifies outliers in Nonparametric Frontier.
This function applies the developed technique by Sousa and Stosic (2005)
Technical Efficiency of the Brazilian Municipalities: Correcting Nonparametric
Frontier Meansurements for Outliers and to use the K-S test with criterion to define outliers.}
\usage{
jackstrap_ks(data, jackstrap_obj, num_cores = 1, perc = 0.9)
}
\arguments{
\item{data}{is the dataset with input and output used to measure efficiency; Dataset need to have this form: 1th column: name of DMU (string); 2th column: code of DMU (integer); n columns of output variables; n columns of input variables.}

\item{jackstrap_obj}{is the object created by the function jackstrap.}

\item{num_cores}{is the number of cores available to process.}

\item{perc}{is the percentage of DMU analyzed by K-S test.}
}
\value{
Return the jackstrap object increased with informations as follows: "result_kstest_method" is p-values of K-S test obtained by removing sequencially one by one the high leverage DMU;
"efficiency_ks_method" is efficiency indicators obtained by K-S test criterion.
}
\description{
Jackstrap KS Method: Tool identifies outliers in Nonparametric Frontier.
This function applies the developed technique by Sousa and Stosic (2005)
Technical Efficiency of the Brazilian Municipalities: Correcting Nonparametric
Frontier Meansurements for Outliers and to use the K-S test with criterion to define outliers.
}
\examples{
 \dontshow{
   library(jackstrap)
   test_data <- data.frame(mun=c(1:10), cod=c(1:10), y=c(5,7,6,7,4,6,8,9,3,1),
                           x=c(7,8,10,22,15,7,22,17,10,5))
   effic_test <- jackstrap (data=test_data, ycolumn=1, xcolumn=1, bootstrap=1,
                 perc_sample_bubble=1, dea_method="crs", orientation_dea="in",
                 n_seed = 2000, repos=FALSE, num_cores=1)
   effic_ks <- jackstrap_ks (data=test_data, jackstrap_obj=effic_test,
                              num_cores = 1)
 }
 \donttest{
    #Command measures efficiency with jackstrap method and K-S test criterion
    efficiency_ks <- jackstrap_ks (data=municipalities, jackstrap_obj=efficiency,
                                   num_cores = 4)
 }
}
