% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jam-call-fn-ellipsis.R
\name{call_fn_ellipsis}
\alias{call_fn_ellipsis}
\title{Safely call a function using ellipsis}
\usage{
call_fn_ellipsis(FUN, ...)
}
\arguments{
\item{FUN}{\code{function} that should be called with arguments in \code{...}}

\item{...}{arguments are passed to \code{FUN()} in safe manner.}
}
\value{
output from \code{FUN()} when called with relevant named arguments
from ellipsis \code{...}
}
\description{
Safely call a function using ellipsis
}
\details{
This function is a wrapper function intended to help
pass ellipsis arguments \code{...} from a parent function
to an external function in a safe way. It will only
include arguments from \code{...} that are recognized by
the external function.

The logic is described as follows:
\itemize{
\item When the external function \code{FUN} arguments \code{formals()} include
ellipsis \code{...}, then the ellipsis \code{...} will be passed as-is without
change. In this way, any arguments inside the original ellipsis \code{...}
will either match arguments in \code{FUN}, or will be ignored in that
function ellipsis \code{...}.
\item When the external function \code{FUN} arguments \code{formals()} do not
include ellipsis \code{...}, then named arguments in \code{...} are passed
to \code{FUN} only when the arguments names are recognized by \code{FUN}.
}

Note that arguments therefore must be named.
}
\examples{
new_mean <- function(x, trim=0, na.rm=FALSE) {
   mean(x, trim=trim, na.rm=na.rm)
}
x <- c(1, 3, 5, NA);
new_mean(x, na.rm=TRUE);
# throws an error as expected (below)
tryCatch({
   new_mean(x, na.rm=TRUE, color="red")
}, error=function(e){
   print("Error is expected, shown below:");
   print(e)
})

call_fn_ellipsis(new_mean, x=x, na.rm=TRUE, color="red")

}
\seealso{
Other jam practical functions: 
\code{\link{breakDensity}()},
\code{\link{checkLightMode}()},
\code{\link{check_pkg_installed}()},
\code{\link{colNum2excelName}()},
\code{\link{color_dither}()},
\code{\link{exp2signed}()},
\code{\link{getAxisLabel}()},
\code{\link{isFALSEV}()},
\code{\link{isTRUEV}()},
\code{\link{jargs}()},
\code{\link{kable_coloring}()},
\code{\link{lldf}()},
\code{\link{log2signed}()},
\code{\link{middle}()},
\code{\link{minorLogTicks}()},
\code{\link{newestFile}()},
\code{\link{printDebug}()},
\code{\link{reload_rmarkdown_cache}()},
\code{\link{renameColumn}()},
\code{\link{rmInfinite}()},
\code{\link{rmNA}()},
\code{\link{rmNAs}()},
\code{\link{rmNULL}()},
\code{\link{setPrompt}()}
}
\concept{jam practical functions}
