% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-clrange.R
\name{fixYellowHue}
\alias{fixYellowHue}
\title{Fix yellow color hue}
\usage{
fixYellowHue(HCL, Hrange = c(80, 90), Hshift = -15, ...)
}
\arguments{
\item{HCL}{numeric matrix with HCL color values, as returned by \code{col2hcl()},
but requiring only one rowname \code{"H"} representing the color hue on
a scale of 0 to 360. If input data does not contain numeric values
with rowname "H", \code{HCL} is return unchanged.}

\item{Hrange}{numeric vector whose range defines the region of hues
to be adjusted. By default hues between 80 and 90 are adjusted. If
NULL, \code{HCL} is return unchanged.}

\item{Hshift}{numeric value length one, used to adjust the hue of colors
within the range \code{Hrange}. If NULL, \code{HCL} is return unchanged.}

\item{...}{additional arguments are ignored.}
}
\value{
returns the input \code{HCL} data where rowname \code{"H"} has hue values
adjusted accordingly. In the event \code{HCL}, \code{Hrange}, or \code{Hshift} have
length 0, the original \code{HCL} is returned. If input data does not
meet the expected format, the input \code{HCL} is returned unchanged.
}
\description{
Fix yellow color hue to be less green than default "yellow"
}
\details{
This function "fixes" the color yellow, which by default appears green
especially when darkened. The effect of this function is to make yellows
appear more red, which appears more visibly yellow even when the color
is darkened.

This function is intended to be tolerant to missing values. For example if
any of the values \code{HCL}, \code{Hrange}, or \code{Hshift} are length 0, the original
\code{HCL} is returned unchanged.
}
\examples{
yellows <- vigrep("yellow", grDevices::colors());
yellowsHCL <- col2hcl(yellows);
fixedYellowsHCL <- fixYellowHue(yellowsHCL);
fixedYellows <- hcl2col(fixedYellowsHCL);
showColors(list(yellows=yellows,
   fixedYellows=fixedYellows));

}
\seealso{
Other jam color functions: 
\code{\link{alpha2col}()},
\code{\link{applyCLrange}()},
\code{\link{col2alpha}()},
\code{\link{col2hcl}()},
\code{\link{col2hsl}()},
\code{\link{col2hsv}()},
\code{\link{color2gradient}()},
\code{\link{fixYellow}()},
\code{\link{getColorRamp}()},
\code{\link{hcl2col}()},
\code{\link{hsl2col}()},
\code{\link{hsv2col}()},
\code{\link{isColor}()},
\code{\link{kable_coloring}()},
\code{\link{makeColorDarker}()},
\code{\link{rainbow2}()},
\code{\link{rgb2col}()},
\code{\link{setCLranges}()},
\code{\link{setTextContrastColor}()},
\code{\link{showColors}()},
\code{\link{unalpha}()},
\code{\link{warpRamp}()}
}
\concept{jam color functions}
