% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-string.r
\name{gsubOrdered}
\alias{gsubOrdered}
\title{Global substitution into ordered factor}
\usage{
gsubOrdered(
  pattern,
  replacement,
  x,
  ignore.case = FALSE,
  perl = FALSE,
  fixed = FALSE,
  useBytes = FALSE,
  sortFunc = mixedSort,
  ...
)
}
\arguments{
\item{pattern, replacement, x, ignore.case, perl, fixed, useBytes}{arguments sent to \code{base::gsub()}}

\item{sortFunc}{function used to sort factor levels, which
is not performed if the input \code{x} is a \code{factor}.}

\item{...}{additional arguments are passed to \code{sortFunc}}
}
\value{
factor whose levels are based upon the order of
input levels when the input \code{x} is a factor; or if the
input \code{x} is not a factor, it is converted to a factor
using the provided sort function \code{sortFunc}.
}
\description{
Global substitution into ordered factor
}
\details{
This function is an extension of \code{base::gsub()} that
returns an ordered factor output. When input is also a
factor, the output factor levels are retained in the
same order, after applying the string substitution.

This function is very useful when making changes via \code{base::gsub()}
to a factor with ordered levels, because it retains the
the order of levels after modification.

Tips:
\itemize{
\item To convert a character vector to a factor, whose levels are
sorted, use \code{sortFunc=sort}.
\item To convert a character vector to a factor, whose levels are
the order they appear in the input \code{x}, use \code{sortFunc=c}.
\item To convert a character vector to a factor, whose levels are
sorted alphanumerically, use \code{sortFunc=mixedSort}.
}
}
\examples{
x <- c(paste0(
   rep(c("first", "second", "third"), 2),
   rep(c("Section", "Choice"), each=3)),
   "Choice");
f <- factor(x, levels=x);
f;

# default gsub() will return a character vector
gsub("(first|second|third)", "", f)
# converting to factor resets the factor level order
factor(gsub("(first|second|third)", "", f))

## gsubOrdered() maintains the factor level order
gsubOrdered("(first|third)", "", f)
gsubOrdered("(first)", "", f)

# to convert character vector to factor, levels in order they appear
gsubOrdered("", "", x, sortFunc=c)

# to convert character vector to factor, levels alphanumeric sorted
gsubOrdered("", "", x, sortFunc=mixedSort)

}
\seealso{
Other jam string functions: 
\code{\link{asSize}()},
\code{\link{breaksByVector}()},
\code{\link{fillBlanks}()},
\code{\link{formatInt}()},
\code{\link{gsubs}()},
\code{\link{makeNames}()},
\code{\link{nameVector}()},
\code{\link{nameVectorN}()},
\code{\link{padInteger}()},
\code{\link{padString}()},
\code{\link{pasteByRow}()},
\code{\link{pasteByRowOrdered}()},
\code{\link{sizeAsNum}()},
\code{\link{tcount}()},
\code{\link{ucfirst}()}
}
\concept{jam string functions}
