% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join_repair.R
\name{join_repair}
\alias{join_repair}
\title{Repair Common Key Issues}
\usage{
join_repair(
  x,
  y = NULL,
  by,
  trim_whitespace = TRUE,
  standardize_case = NULL,
  remove_invisible = TRUE,
  empty_to_na = FALSE,
  dry_run = FALSE
)
}
\arguments{
\item{x}{A data frame (left table).}

\item{y}{A data frame (right table). If NULL, only repairs x.}

\item{by}{A character vector of column names to repair.}

\item{trim_whitespace}{Logical. Trim leading/trailing whitespace. Default TRUE.}

\item{standardize_case}{Character. Standardize case to "lower", "upper", or
NULL (no change). Default NULL.}

\item{remove_invisible}{Logical. Remove invisible Unicode characters. Default TRUE.}

\item{empty_to_na}{Logical. Convert empty strings to NA. Default FALSE.}

\item{dry_run}{Logical. If TRUE, only report what would be changed without
modifying data. Default FALSE.}
}
\value{
If \code{y} is NULL, returns the repaired \code{x}. If both are provided,
returns a list with \code{x} and \code{y}. In dry_run mode, returns a summary of
proposed changes.
}
\description{
Automatically fixes trivial join key issues like whitespace and case
mismatches. Returns the repaired data frame(s) with a summary of changes.
}
\examples{
# Data with whitespace issues
orders <- data.frame(
  id = c(" A", "B ", "C"),
  value = 1:3,
  stringsAsFactors = FALSE
)

# Dry run to see what would change
join_repair(orders, by = "id", dry_run = TRUE)

# Actually repair
orders_fixed <- join_repair(orders, by = "id")

}
\seealso{
\code{\link[=join_spy]{join_spy()}}, \code{\link[=key_check]{key_check()}}
}
