% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pruned_DP_C_access.R
\encoding{utf-8}
\name{Fpsn}
\alias{Fpsn}
\title{Pruned dynamic programming algorithm}
\usage{
Fpsn(x, Kmax, mini = min(x), maxi = max(x))
}
\arguments{
\item{x}{A vector of double : the signal to be segmented}

\item{Kmax}{Max number of segments}

\item{mini}{Min value for the mean parameter of the segment}

\item{maxi}{Max value for the mean parameter of the segment}
}
\value{
A list with a vector containing the position of the change-points
}
\description{
Low-level API for the pruned dynamic programming algorithm (pDPA)
}
\details{
This implementation uses functional pruning and segment neighborhood, and the L2-loss function
}
\examples{

## load known real copy number regions
affyDat <- acnr::loadCnRegionData(dataSet="GSE29172", tumorFraction=1)

## generate a synthetic CN profile
K <- 10
len <- 1e4
sim <- getCopyNumberDataByResampling(len, K, minLength=100, regData=affyDat)
datS <- sim$profile

## run pruned DPA segmentation
res <- Fpsn(datS[["c"]], Kmax=2*K+1)

## plot segmentation results for the true number of breakpoints
bkp <- res$t.est[K+1, 1:K]
plotSeg(datS, breakpoints=bkp)
}
\references{
Rigaill, G. (2015). A pruned dynamic programming algorithm to recover the best segmentations with 1 to K_max change-points. Journal de la Societe Francaise de Statistique, 156(4), 180-205.
}
\seealso{
\code{\link{doDynamicProgramming}} for a higher-level function
}
\author{
Guillem Rigaill
}
