% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_Nbinom.R
\name{Nbinom}
\alias{Nbinom}
\alias{d,Nbinom,numeric-method}
\alias{p,Nbinom,numeric-method}
\alias{qn,Nbinom,numeric-method}
\alias{r,Nbinom,numeric-method}
\alias{mean,Nbinom-method}
\alias{median,Nbinom-method}
\alias{mode,Nbinom-method}
\alias{var,Nbinom-method}
\alias{sd,Nbinom-method}
\alias{skew,Nbinom-method}
\alias{kurt,Nbinom-method}
\alias{entro,Nbinom-method}
\alias{finf,Nbinom-method}
\alias{llnbinom}
\alias{ll,Nbinom,numeric-method}
\alias{enbinom}
\alias{mle,Nbinom,numeric-method}
\alias{me,Nbinom,numeric-method}
\alias{vnbinom}
\alias{avar_mle,Nbinom-method}
\alias{avar_me,Nbinom-method}
\title{Negative Binomial Distribution}
\usage{
Nbinom(size = 1, prob = 0.5)

\S4method{d}{Nbinom,numeric}(distr, x, log = FALSE)

\S4method{p}{Nbinom,numeric}(distr, q, lower.tail = TRUE, log.p = FALSE)

\S4method{qn}{Nbinom,numeric}(distr, p, lower.tail = TRUE, log.p = FALSE)

\S4method{r}{Nbinom,numeric}(distr, n)

\S4method{mean}{Nbinom}(x)

\S4method{median}{Nbinom}(x)

\S4method{mode}{Nbinom}(x)

\S4method{var}{Nbinom}(x)

\S4method{sd}{Nbinom}(x)

\S4method{skew}{Nbinom}(x)

\S4method{kurt}{Nbinom}(x)

\S4method{entro}{Nbinom}(x)

\S4method{finf}{Nbinom}(x)

llnbinom(x, size, prob)

\S4method{ll}{Nbinom,numeric}(distr, x)

enbinom(x, size, type = "mle", ...)

\S4method{mle}{Nbinom,numeric}(distr, x, na.rm = FALSE)

\S4method{me}{Nbinom,numeric}(distr, x, na.rm = FALSE)

vnbinom(size, prob, type = "mle")

\S4method{avar_mle}{Nbinom}(distr)

\S4method{avar_me}{Nbinom}(distr)
}
\arguments{
\item{size}{number of trials (zero or more).}

\item{prob}{numeric. Probability of success on each trial.}

\item{distr}{an object of class \code{Nbinom}.}

\item{x}{For the density function, \code{x} is a numeric vector of quantiles. For
the moments functions, \code{x} is an object of class \code{Nbinom}. For the
log-likelihood and the estimation functions, \code{x} is the sample of
observations.}

\item{log, log.p}{logical. Should the logarithm of the probability be
returned?}

\item{q}{numeric. Vector of quantiles.}

\item{lower.tail}{logical. If TRUE (default), probabilities are
\eqn{P(X \leq x)}, otherwise \eqn{P(X > x)}.}

\item{p}{numeric. Vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to
be the number required.}

\item{type}{character, case ignored. The estimator type (mle or me).}

\item{...}{extra arguments.}

\item{na.rm}{logical. Should the \code{NA} values be removed?}
}
\value{
Each type of function returns a different type of object:
\itemize{
\item Distribution Functions: When supplied with one argument (\code{distr}), the
\code{d()}, \code{p()}, \code{q()}, \code{r()}, \code{ll()} functions return the density, cumulative
probability, quantile, random sample generator, and log-likelihood functions,
respectively. When supplied with both arguments (\code{distr} and \code{x}), they
evaluate the aforementioned functions directly.
\item Moments: Returns a numeric, either vector or matrix depending on the moment
and the distribution. The \code{moments()} function returns a list with all the
available methods.
\item Estimation: Returns a list, the estimators of the unknown parameters. Note
that in distribution families like the binomial, multinomial, and negative
binomial, the size is not returned, since it is considered known.
\item Variance: Returns a named matrix. The asymptotic covariance matrix of the
estimator.
}
}
\description{
The Negative Binomial distribution is a discrete probability distribution
that models the number of failures before a specified number of successes
occurs in a sequence of independent Bernoulli trials. It is defined by
parameters \eqn{r > 0} (number of successes) and \eqn{0 < p \leq 1}
(probability of success).
}
\details{
The probability mass function (PMF) of the negative binomial distribution is:
\deqn{ P(X = k) = \binom{k + r - 1}{k} (1 - p)^k p^r, \quad k \in
\mathbb{N}_0.}
}
\examples{
# -----------------------------------------------------
# Negative Binomial Distribution Example
# -----------------------------------------------------

# Create the distribution
N <- 10 ; p <- 0.4
D <- Nbinom(N, p)

# ------------------
# dpqr Functions
# ------------------

d(D, 0:4) # density function
p(D, 0:4) # distribution function
qn(D, c(0.4, 0.8)) # inverse distribution function
x <- r(D, 100) # random generator function

# alternative way to use the function
df <- d(D) ; df(x) # df is a function itself

# ------------------
# Moments
# ------------------

mean(D) # Expectation
median(D) # Median
mode(D) # Mode
var(D) # Variance
sd(D) # Standard Deviation
skew(D) # Skewness
kurt(D) # Excess Kurtosis
entro(D) # Entropy
finf(D) # Fisher Information Matrix

# List of all available moments
mom <- moments(D)
mom$mean # expectation

# ------------------
# Point Estimation
# ------------------

ll(D, x)
llnbinom(x, N, p)

enbinom(x, N, type = "mle")
enbinom(x, N, type = "me")

mle(D, x)
me(D, x)
e(D, x, type = "mle")

# ------------------
# Estimator Variance
# ------------------

vnbinom(N, p, type = "mle")
vnbinom(N, p, type = "me")

avar_mle(D)
avar_me(D)

v(D, type = "mle")
}
\seealso{
Functions from the \code{stats} package: \code{\link[=dnbinom]{dnbinom()}}, \code{\link[=pnbinom]{pnbinom()}}, \code{\link[=qnbinom]{qnbinom()}},
\code{\link[=rnbinom]{rnbinom()}}
}
