% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IndexW.R
\name{IndexW}
\alias{IndexW}
\title{W index value for a single topology.}
\usage{
IndexW(tree = tree)
}
\arguments{
\item{tree}{is a single tree with n terminals, an ape phylo object.}
}
\description{
This function assigns the weight according to the ramification patterns 
(see Van-Wright et al., 1981). 
The input tree is reordered in post order.
Returns a vector with weights.
}
\examples{
  library(jrich)
  data(tree)
  plot(tree)
  indexw             <- IndexW(tree)
  newTree            <- tree
  newTree$tip.label  <- indexw
  plot(newTree)
  


}
\author{
Miranda-Esquivel Daniel R.
}

