% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernels.R
\name{analytic_filter}
\alias{analytic_filter}
\title{analytic_filter}
\usage{
analytic_filter(
  outcomes,
  a1 = 0,
  R1 = 1,
  FF,
  FF.labs,
  G,
  G.labs,
  G.idx,
  D,
  h,
  H,
  p.monit = NA,
  monitoring = FALSE,
  safe.mode = TRUE
)
}
\arguments{
\item{outcomes}{list: The observed data. It should contain objects of the class dlm_distr.}

\item{a1}{numeric: The prior mean at the latent vector.}

\item{R1}{matrix: The prior covariance matrix at the latent vector.}

\item{FF}{array: A 3D-array containing the planning matrix at each time. Its dimension should be n x k x t, where n is the number of latent states, k is the number of linear predictors in the model and t is the time series length.}

\item{FF.labs}{matrix: A character matrix containing the label associated with each value in FF.}

\item{G}{array: A 3D-array containing the evolution matrix at each time. Its dimension should be n x n x t, where n is the number of latent states and t is the time series length.}

\item{G.labs}{matrix: A character matrix containing the label associated with each value in G.}

\item{G.idx}{matrix: A numeric matrix containing the index associated with each value in G.}

\item{D}{array: A 3D-array containing the discount factor matrix at each time. Its dimension should be n x n x t, where n is the number of latent states and t is the time series length.}

\item{h}{matrix: A drift to be added after the temporal evolution (can be interpreted as the mean of the random noise at each time). Its dimension should be n x t, where t is the length of the series and n is the number of latent states.}

\item{H}{array: A 3D-array containing the covariance matrix of the noise at each time. Its dimension should be the same as D.}

\item{p.monit}{numeric (optional): The prior probability of changes in the latent space variables that are not part of its dynamic.}

\item{monitoring}{numeric: A vector of flags indicating which latent states should be monitored.}

\item{safe.mode}{boolean: A flag indicating if consistency check should be performed at each time step. Recommended to be left on, but if you know what you are doing (i.e., you tested the model and it is safe) and need to fit it several times, you can disable the checks to save some time.}
}
\value{
A list containing the following values:
\itemize{
   \item mt matrix: The filtered mean of the latent states for each time. Dimensions are n x t.
   \item Ct array: A 3D-array containing the filtered covariance matrix of the latent states for each time. Dimensions are n x n x t.
   \item at matrix: The one-step-ahead mean of the latent states at each time. Dimensions are n x t.
   \item Rt array: A 3D-array containing the one-step-ahead covariance matrix for latent states at each time. Dimensions are n x n x t.
   \item ft matrix: The one-step-ahead mean of the linear predictors at each time. Dimensions are k x t.
   \item Qt array: A 3D-array containing the one-step-ahead covariance matrix for linear predictors at each time. Dimensions are k x k x t.
   \item ft.star matrix: The filtered mean of the linear predictors for each time. Dimensions are k x t.
   \item Qt.star array: A 3D-array containing the linear predictors matrix of the latent state for each time. Dimensions are k x k x t.
   \item FF array: The same as the argument (same values).
   \item G matrix: The same as the argument (same values).
   \item G.labs matrix: The same as the argument (same values).
   \item G.idx matrix: The same as the argument (same values).
   \item D array: The same as the argument (same values).
   \item h array: The same as the argument (same values).
   \item H array: The same as the argument (same values).
   \item W array: A 3D-array containing the effective covariance matrix of the noise for each time, i.e., considering both H and D. Its dimension are the same as H and D.
   \item monitoring numeric: The same as the argument (same values).
   \item outcomes list: The same as the argument outcomes (same values).
   \item pred.names numeric: The names of the linear predictors.
   \item safe.mode bool: The same as the argument outcomes (same values).
}
}
\description{
Fit a model given the observed value and the model parameters.
}
\details{
For the models covered in this package, we always use the approach described in \insertCite{ArtigokParametrico;textual}{kDGLM}, including, in particular, the filtering algorithm presented in that work.

For the details about the implementation see \insertCite{ArtigoPacote;textual}{kDGLM}.

For the details about the algorithm implemented see \insertCite{ArtigokParametrico;textual}{kDGLM}, \insertCite{Petris-DLM;textual}{kDGLM}, chapter 2, \insertCite{WestHarr-DLM;textual}{kDGLM}, chapter 4, and \insertCite{Kalman_filter_origins;textual}{kDGLM}.
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{fit_model}}

\code{\link{generic_smoother}}
}
\keyword{internal}
