% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Jfunctions.R
\name{J1}
\alias{J1}
\title{J1}
\usage{
J1(u, cc = sqrt(5/3))
}
\arguments{
\item{u}{Numeric vector.}

\item{cc}{Numeric constant, defaults to \eqn{\sqrt(5/3)}.}
}
\value{
Vector of same length and mode as \code{u}.
}
\description{
Eq. (15.16) in Eichner (2017) as a result of Cardano's formula.
}
\details{
Using, for brevity's sake, \eqn{J_{1a}(u, c) := -q_c(u)} and
\eqn{J_{1b}(u, c) := J_{1a}(u, c)^2 + p_c^3}, the definition of
\eqn{J_1} reads:

\eqn{J_1(u, c) :=   [J_{1a}(u, c) + \sqrt(J_{1b}(u, c))]^{1/3}
                  + [J_{1a}(u, c) - \sqrt(J_{1b}(u, c))]^{1/3}}.

For implementation details of \eqn{q_c(u)} and \eqn{p_c} see
\code{\link{qc}} and \code{\link{pc}}, respectively.

For further mathematical details see Eichner (2017) and/or Eichner
& Stute (2013).
}
\note{
Eq. (15.16) in Eichner (2017), and hence \eqn{J_1(u, c)}, requires
      \eqn{c} to be in \eqn{[\sqrt(5/3), 3)}. If \code{cc} does
      not satisfy this requirement a warning (only) is issued.
}
\examples{
\donttest{
u <- seq(0, 1, by = 0.01)
c0 <- expression(sqrt(5/3))
c1 <- expression(sqrt(3) - 0.01)
cgrid <- c(1.35, seq(1.4, 1.7, by = 0.1))
cvals <- c(eval(c0), cgrid, eval(c1))

Y <- sapply(cvals, function(cc, u) J1(u, cc = cc), u = u)
cols <- rainbow(ncol(Y), end = 9/12)
matplot(u, Y, type = "l", lty = "solid", col = cols,
  ylab = expression(J[1](u, c)))
abline(h = 0)
legend("topleft", title = "c", legend = c(c0, cgrid, c1),
  lty = 1, col = cols, cex = 0.8)
}

}
\seealso{
\code{\link{J_admissible}}.
}
