% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_kaya.R
\name{plot_fuel_mix}
\alias{plot_fuel_mix}
\title{Plot fuel mix}
\usage{
plot_fuel_mix(
  fuel_mix,
  collapse_renewables = TRUE,
  title = NULL,
  colors = NULL,
  font_size = 20
)
}
\arguments{
\item{fuel_mix}{A tibble with the mixture of fuels for one or more countries or regions:
\describe{
\item{region}{The name of the country or region}
\item{fuel}{The name of the fuel}
\item{quads}{The number of quads per year the country or region consumes}
\item{frac}{The fraction of the country's energy that comes from that fuel}
}}

\item{collapse_renewables}{Combine hydroelectricity and other renewables into
a single category.}

\item{title}{Include a title on the plot. If \code{title} is \code{NULL} (default)
or \code{TRUE}, a default title is created from the names of the regions in
\code{fuel_mix}.
If \code{title} is a character string, that string is used.
If \code{title} is \code{FALSE}, the plot is produced with no title.}

\item{colors}{A named vector with the colors to use for
\code{Coal}, \code{Oil}, \verb{Natural Gas}, \code{Nuclear}, \code{Hydro}, and \code{Renewables}.}

\item{font_size}{The base font size.}
}
\value{
A plot object.
}
\description{
Plot fuel mix
}
\examples{
usa_fuel <- get_fuel_mix("United States", collapse_renewables = FALSE)
plot_fuel_mix(usa_fuel)
plot_fuel_mix(usa_fuel, collapse_renewables = FALSE)
plot_fuel_mix(usa_fuel, collapse_renewables = FALSE,
              colors = c(Coal = "black", "Natural Gas" = "gray60",
                         Oil = "gray30", Nuclear = "forestgreen",
                         Hydro = "royalblue", Renewables="palegreen"))
plot_fuel_mix("United States")
plot_fuel_mix("USA")

}
