% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/predict.kernelFactory.R
\name{predict.kernelFactory}
\alias{predict.kernelFactory}
\title{Predict method for kernelFactory objects}
\usage{
\method{predict}{kernelFactory}(object, newdata = NULL, predict.all = FALSE,
  ...)
}
\arguments{
\item{object}{An object of class \code{kernelFactory}, as created by the function \code{kernelFactory}}

\item{newdata}{A data frame with the same predictors as in the training data.}

\item{predict.all}{TRUE or FALSE. If TRUE and rp and cp are 1 then the individual predictions of the random forest are returned. If TRUE and any of rp and cp or bigger than 1 then the predictions of all the members are returned.}

\item{...}{Not used currently.}
}
\value{
A vector containing the response probabilities.
}
\description{
Prediction of new data using kernelFactory.
}
\examples{
#Credit Approval data available at UCI Machine Learning Repository
data(Credit)
#take subset (for the purpose of a quick example) and train and test
Credit <- Credit[1:100,]
train.ind <- sample(nrow(Credit),round(0.5*nrow(Credit)))

#Train Kernel Factory on training data
kFmodel <- kernelFactory(x=Credit[train.ind,names(Credit)!= "Response"],
          y=Credit[train.ind,"Response"], method=random)

#Deploy Kernel Factory to predict response for test data
predictedresponse <- predict(kFmodel, newdata=Credit[-train.ind,names(Credit)!= "Response"])
}
\author{
Authors: Michel Ballings and Dirk Van den Poel, Maintainer: \email{Michel.Ballings@GMail.com}
}
\references{
Ballings, M. and Van den Poel, D. (2013), Kernel Factory: An Ensemble of Kernel Machines. Expert Systems With Applications, 40(8), 2904-2913.
}
\seealso{
\code{\link{kernelFactory}}
}
\keyword{classification}

