% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snapshot.R
\name{check_drift}
\alias{check_drift}
\title{Check for drift from committed snapshot}
\usage{
check_drift(.data, reference = NULL)
}
\arguments{
\item{.data}{A data frame with a snapshot reference.}

\item{reference}{Optional content hash to compare against.
If NULL, uses the attached snapshot reference.}
}
\value{
A drift report (class \code{keyed_drift_report}), or NULL if no
snapshot found.
}
\description{
Compares current data against its committed reference snapshot.
Returns diagnostic information about changes.
}
\examples{
df <- key(data.frame(id = 1:3, x = c("a", "b", "c")), id)
df <- commit_keyed(df)

# Modify the data
df$x[1] <- "modified"
check_drift(df)

}
