% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keyplayer.R
\name{diffusion}
\alias{diffusion}
\title{Compute the Diffusion Centrality Score in a Network}
\usage{
diffusion(adj.matrix, node, T = ncol(adj.matrix))
}
\arguments{
\item{adj.matrix}{Matrix indicating the probability matrix.}

\item{node}{Integer indicating the column index of the chosen player
in the adjacenncy matrix. If not specified, scores for all nodes will be reported.}

\item{T}{Integer indicating the maximum number of iterations
of communication process. In the first iteration, the adjacency matrix
is as the input. In the nth iteration, the adjacency matrix becomes
the input adjacency matrix to the power of n. By default, T is the network size.}
}
\value{
A vector indicating the defusion centrality score(s) of
the chosen player(s).
}
\description{
\code{diffusion} measures player's ability to disseminate information through all the
possible paths. For each path from i to j there is a reaching probability
\eqn{P_{ij}}{P_{ij}}, which is specified in the inputted adjacency matrix.
}
\details{
The diffusion centrality measures the expected number of information receivers from a particular node (Banerjee et.al. 2013). The measure can approximate the degree, Katz-Bonacich, or
eigenvector centrality when proper parameters are chosen. See Banerjee et.al. (2014) for details and proofs.

In its original parametrization (Banerjee et.al. 2013), P=q*g, where q is a measure of the information passing probability and g the adjacency matrix. For simplication and consistency with other centrality measures, the current packages asks users to input the probability matrix P directly.
With information on q and the adjacency matrix, the probability matrix P can easily be calculated by their product.
}
\examples{
# Create a 5x5 weighted and directed adjacency matrix, where edge values
# represent the strength of tie
W <- matrix(
  c(0,1,3,0,0,
    0,0,0,4,0,
    1,1,0,2,0,
    0,0,0,0,3,
    0,2,0,0,0),
    nrow=5, ncol=5, byrow = TRUE)

# Transform the edge value to probability interpretaion
P <- W *0.2

# List the diffusion centrality score for every node
diffusion(P, T = 2)

}
\references{
An, Weihua and Yu-Hsin Liu (2016). "keyplayer: An R Package for Locating Key Players in Social Networks."
\emph{The R Journal}, 8(1): 257-268.\cr

Banerjee, A., A. Chandrasekhar, E. Duflo, and M. Jackson (2013):
"Diffusion of Microfinance," \emph{Science}, Vol. 341. p.363\cr

Banerjee, A., A. Chandrasekhar, E. Duflo, and M. Jackson (2014):
"Gossip: Identifying Central Individuals in a Social Network,"
Working Paper.\cr
}
\seealso{
\code{\link[matpow]{matpow}};
\code{\link{kpcent}};
\code{\link{kpset}}
}
\author{
Weihua An \email{weihua.an@emory.edu}; Yu-Hsin Liu \email{ugeneliu@meta.com}
}
