% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/egfr_other_adults.R
\name{egfr.bis.cr_cys}
\alias{egfr.bis.cr_cys}
\title{Calculate eGFR by the Berlin Initiative Study (BIS2) creatinine-cystatin C-based equation}
\usage{
egfr.bis.cr_cys(
  creatinine,
  cystatin,
  age,
  sex,
  creatinine_units = "micromol/l",
  cystatin_units = "mg/l",
  label_sex_male = c("Male", 1),
  label_sex_female = c("Female", 0),
  max_age = 100
)
}
\arguments{
\item{creatinine}{Numeric vector. Serum creatinine, could be expressed in "micromol/L", "mmol/L" or "mg/dL". Units of measurement should be defined in variable creatinine_units (if not defined explicitly by user, the default value is "micromol/L").}

\item{cystatin}{Numeric vector. Serum cystatin, could be expressed in "mg/L" or "nanomol/L". Units of measurement should be defined in variable cystatin_units (if not defined explicitly by user, the default value is "mg/L").}

\item{age}{Numeric vector. Age, in years.}

\item{sex}{Vector. The value of variable refers to the parameters label_sex_male and label_sex_female.}

\item{creatinine_units}{Character string. Units in which serum creatinne is expressed. Could be one of the following: "micromol/L", "mmol/L" or "mg/dL".}

\item{cystatin_units}{Character string. Units in which serum cystatin is expressed. Could be one of the following: "mg/L" or "nanomol/L"}

\item{label_sex_male}{List. Label(s) for definition(s) of male sex.}

\item{label_sex_female}{List. Label(s) for definition(s) of female sex.}

\item{max_age}{Numeric. Maximal age suitable for the equation application, in years. By default is 100 years, but change this value in case you would like to apply equation to older persons.}
}
\value{
numeric eGFR expressed in ml/min/1.73m\ifelse{html}{\out{<sup>2</sup>}}{\eqn{^2}}.
}
\description{
Calculate eGFR by the Berlin Initiative Study (BIS2) creatinine-cystatin C-based equation
}
\details{
Calculate estimated glomerular filtration rate (eGFR) by the Berlin Initiative Study (BIS2) creatinine-cystatin C-based equation.

Reference to the equation: Schaeffner ES, Ebert N, Delanaye P et al. Two novel equations to estimate kidney function in persons aged 70 years or older. Ann Intern Med 2012; 157: 471–481  doi: 10.7326/0003-4819-157-7-201210020-00003.

Citation: Bikbov B. kidney.epi: Kidney-Related Functions for Clinical and Epidemiological Research. Scientific-Tools.Org, https://Scientific-Tools.Org. DOI: 10.32614/CRAN.package.kidney.epi
}
\examples{
# for a single patient
egfr.bis.cr_cys (creatinine = 1.4, cystatin = 1.0, age = 80,
   sex = "Male", creatinine_units = "mg/dl",
   cystatin_units = "mg/L")
# for a dataset - see vignettes for details
# egfr.bis.cr_cys (creatinine = dta$scr, cystatin = dta$cys, 
#   age = dta$age, sex = dta$sex, 
#   creatinine_units = "mg/dl", cystatin_units = "mg/l")
}
\author{
Programming: Boris Bikbov https://www.linkedin.com/in/boris-bikbov.
}
