% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kld-analytical.R
\name{kld_uniform_gaussian}
\alias{kld_uniform_gaussian}
\title{Analytical KL divergence between a uniform and a Gaussian distribution}
\usage{
kld_uniform_gaussian(a = 0, b = 1, mu = 0, sigma2 = 1)
}
\arguments{
\item{a, b}{Parameters of uniform (true) distribution}

\item{mu, sigma2}{Parameters of Gaussian (approximate) distribution}
}
\value{
A scalar (the Kullback-Leibler divergence)
}
\description{
This function computes \eqn{D_{KL}(p||q)}, where \eqn{p\sim \text{U}(a,b)}
and \eqn{q\sim \mathcal{N}(\mu,\sigma^2)}.
}
\examples{
kld_uniform_gaussian(a = 0, b = 1, mu = 0, sigma2 = 1)
}
