% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Kmer_Table.R
\name{Kmer_Table}
\alias{Kmer_Table}
\title{A R6 class wrapper for data.table}
\description{
A R6 class wrapper for data.table

A R6 class wrapper for data.table
}
\details{
A way to grow data.table in different environment but still retaining access
to it. A temporary fix until data.table developer develop update row
by reference.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{DT}}{data.table of k-mers}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Kmer_Table-new}{\code{Kmer_Table$new()}}
\item \href{#method-Kmer_Table-print}{\code{Kmer_Table$print()}}
\item \href{#method-Kmer_Table-remove_N}{\code{Kmer_Table$remove_N()}}
\item \href{#method-Kmer_Table-filter_central_pattern}{\code{Kmer_Table$filter_central_pattern()}}
\item \href{#method-Kmer_Table-update_count}{\code{Kmer_Table$update_count()}}
\item \href{#method-Kmer_Table-update_row}{\code{Kmer_Table$update_row()}}
\item \href{#method-Kmer_Table-clone}{\code{Kmer_Table$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Kmer_Table-new"></a>}}
\if{latex}{\out{\hypertarget{method-Kmer_Table-new}{}}}
\subsection{Method \code{new()}}{
initialize empty data.table of k-mers
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kmer_Table$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Kmer_Table-print"></a>}}
\if{latex}{\out{\hypertarget{method-Kmer_Table-print}{}}}
\subsection{Method \code{print()}}{
Print method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kmer_Table$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Kmer_Table-remove_N"></a>}}
\if{latex}{\out{\hypertarget{method-Kmer_Table-remove_N}{}}}
\subsection{Method \code{remove_N()}}{
Remove unknown base N.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kmer_Table$remove_N()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Kmer_Table-filter_central_pattern"></a>}}
\if{latex}{\out{\hypertarget{method-Kmer_Table-filter_central_pattern}{}}}
\subsection{Method \code{filter_central_pattern()}}{
Filter out k-mers without defined central patterns.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kmer_Table$filter_central_pattern(central.pattern, k)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{central.pattern}}{Central pattern.}

\item{\code{k}}{Length of k-mer.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Kmer_Table-update_count"></a>}}
\if{latex}{\out{\hypertarget{method-Kmer_Table-update_count}{}}}
\subsection{Method \code{update_count()}}{
Update count for existed k-mers in the table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kmer_Table$update_count(kmers, is.strand.sensitive, strand)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{kmers}}{K-mer table with new count to be added to the main table.}

\item{\code{is.strand.sensitive}}{Does strand polarity matter?}

\item{\code{strand}}{If yes, what is the strand refers to? "+" or "-".}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Kmer_Table-update_row"></a>}}
\if{latex}{\out{\hypertarget{method-Kmer_Table-update_row}{}}}
\subsection{Method \code{update_row()}}{
Add new rows for new k-mers with their respective counts that is not
existed yet in the main table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kmer_Table$update_row(kmers, is.strand.sensitive, strand)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{kmers}}{K-mer table with new k-mers to be added to the main table.}

\item{\code{is.strand.sensitive}}{Does strand polarity matter?}

\item{\code{strand}}{If yes, what is the strand refers to? "+" or "-".}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Kmer_Table-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Kmer_Table-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kmer_Table$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
