% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCORE.R
\name{SCORE}
\alias{SCORE}
\title{Calculate susceptibility scores for k-mers in case and control regions.}
\usage{
SCORE(
  case.coor.path,
  genome.name,
  strand.sensitive,
  k,
  ctrl.rel.pos,
  case.pattern,
  output.path,
  case,
  genome,
  control,
  control.path,
  genome.path,
  rm.case.kmer.overlaps,
  single.case.len,
  merge.replicates,
  rm.dup,
  case.coor.1st.idx,
  ctrl.coor.1st.idx,
  coor.load.limit,
  genome.load.limit,
  genome.fasta.style,
  genome.ncbi.db,
  use.UCSC.chr.name,
  verbose
)
}
\arguments{
\item{case.coor.path}{Path to the file containing genomic coordinates of case regions.}

\item{genome.name}{Name of the genome to be used.}

\item{strand.sensitive}{Logical indicating whether strand information should be considered.}

\item{k}{Integer size of the expanded k-mer.}

\item{ctrl.rel.pos}{Relative positions of control regions with respect to case regions.
It should be a vector of two integers indicating the upstream and downstream
distances from the case regions.}

\item{case.pattern}{Regular expression pattern to identify the central sequence in case regions.}

\item{output.path}{Directory path where the output files will be saved.}

\item{case}{Data.table containing the genomic coordinates of case regions.}

\item{genome}{Genome data.table containing the genomic sequence information.}

\item{control}{Data.table containing the genomic coordinates of control regions.}

\item{control.path}{Path to the file containing genomic coordinates of control regions (optional).}

\item{genome.path}{Path to the genome FASTA file.}

\item{rm.case.kmer.overlaps}{Logical indicating whether overlapping k-mers within case regions should be removed.}

\item{single.case.len}{Single case length.}

\item{merge.replicates}{Logical indicating whether replicates should be merged.}

\item{rm.dup}{Logical indicating whether duplicate k-mers should be removed.}

\item{case.coor.1st.idx}{First index in the case coordinate file.}

\item{ctrl.coor.1st.idx}{First index in the control coordinate file.}

\item{coor.load.limit}{Maximum number of coordinates to load.}

\item{genome.load.limit}{Maximum number of genome sequences to load.}

\item{genome.fasta.style}{FASTA style.}

\item{genome.ncbi.db}{NCBI database.}

\item{use.UCSC.chr.name}{Logical indicating whether to use UCSC chromosome names.}

\item{verbose}{Logical indicating whether to display progress messages.}
}
\value{
Data.table containing susceptibility scores for k-mers.
}
\description{
Function calculates susceptibility scores for k-mers in case and control regions.
Case regions are defined by genomic coordinates provided in a file or data.table.
Control regions can be constructed relative to the case regions or provided directly.
The scores are computed based on the occurrence of k-mers in case and control regions.
}
