% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getEnsemblVariantFeatures.R
\name{getEnsemblVariantFeatures}
\alias{getEnsemblVariantFeatures}
\title{Get features of given variant IDs.}
\usage{
getEnsemblVariantFeatures(
  species,
  variant.ids,
  include.genotypes = FALSE,
  include.phenotypes = FALSE,
  include.allele.frequencies = FALSE,
  include.genotype.frequencies = FALSE,
  curl.max.con = 100,
  verbose = 1
)
}
\arguments{
\item{species}{Species name or alias (e.g., homo_sapiens, human).}

\item{variant.ids}{A vector of variant IDs (e.g., rs56116432, COSM476).}

\item{include.genotypes}{Include genotypes in the response? Default FALSE.}

\item{include.phenotypes}{Include phenotypes in the response? Default FALSE.}

\item{include.allele.frequencies}{Include allele frequencies? Default FALSE.}

\item{include.genotype.frequencies}{Include genotype frequencies? Default FALSE.}

\item{curl.max.con}{Maximum number of concurrent connections for curl requests.
Default is 100.}

\item{verbose}{Verbosity level: 1 for error only, 2 for all requests. Default 1.}
}
\value{
A variant-named list containing lists of variant features.
}
\description{
Function retrieves features for given variant IDs from the Ensembl
database. It handles requests asynchronously in batches due to server limits
and includes options to fetch additional variant information. Error handling
for different HTTP response statuses is implemented to manage request failures.
}
