% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getUCSCgenePredTable.R
\name{getUCSCgenePredTable}
\alias{getUCSCgenePredTable}
\title{Retrieve Gene Prediction Table from UCSC for a Given Genome}
\usage{
getUCSCgenePredTable(genome.name, db)
}
\arguments{
\item{genome.name}{A string specifying the UCSC genome name for which the gene
prediction table is to be retrieved, e.g., 'hg38', 'mm39'.}

\item{db}{A string specifying the database used by UCSC to generate the table.
Options are 'refseq' or 'gencode'.}
}
\value{
A \code{data.table} containing the gene prediction table from the specified
UCSC genome and database.
}
\description{
This function retrieves the gene prediction table from the UCSC genome database
for a specified genome. It can fetch data from either the RefSeq or GENCODE databases.
}
