% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadCoordinate.R
\name{loadCoordinate}
\alias{loadCoordinate}
\title{Build Coordinate object.}
\usage{
loadCoordinate(
  root.path = NULL,
  single.len = NULL,
  is.strand.sensitive = TRUE,
  merge.replicates = TRUE,
  rm.dup = TRUE,
  add.col.rep = FALSE,
  is.kmer = FALSE,
  k = NA,
  ori.first.index = 1,
  load.limit = 1
)
}
\arguments{
\item{root.path}{A path to a directory containing either:
(1) chromosome-separated coordinate files
(multiple replicates is assumed for sub-folder) or
(2) bedfile (multiple replicates is assumed for separate bedfiles).}

\item{single.len}{Single case length relevant when all coordinates have the
same length. This is for memory optimization. Default is NULL.}

\item{is.strand.sensitive}{A boolean whether strand polarity matters.
Default is TRUE.}

\item{merge.replicates}{Merge coordinate from different replicates.
Default is TRUE. If not merging, duplicates will give weight to the
k-mer counting. If add.col.rep, merged coordinate will contain
column replicate e.g. "rep1&rep2".}

\item{rm.dup}{Remove duplicates in each replicate. Default is TRUE.}

\item{add.col.rep}{Add column replicate to the coordinate table.}

\item{is.kmer}{Is the coordinate refers to k-mer i.e. expanded case?
Default is FALSE.}

\item{k}{Length of k-mer relevant only when is.kmer is TRUE.}

\item{ori.first.index}{Indexing format of the coordinate:
0 for zero-based (start, end) and 1 for one-based (start, end).
Default is 1.}

\item{load.limit}{Maximum number of coordinate data.table loaded on RAM.
Default is 1.}
}
\value{
Coordinate object.
}
\description{
The Coordinate object is capable of loading genomic coordinates on demand.
Chromosome-specific coordinates can be called in a bracket.
The coordinates can also be expanded to k-mer size equally on both flanks
}
