% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render_xl.R
\name{xl_renderer}
\alias{xl_renderer}
\alias{xl_renderer.default}
\alias{xl_renderer.data.frame}
\alias{xl_renderer.numeric}
\alias{xl_renderer.logical}
\alias{xl_renderer.list}
\alias{xl_renderer.character}
\title{Represents an R object into a format that can be printed into an XLSX file}
\usage{
xl_renderer(x, options)

\method{xl_renderer}{default}(x, options)

\method{xl_renderer}{data.frame}(x, options)

\method{xl_renderer}{numeric}(x, options)

\method{xl_renderer}{logical}(x, options)

\method{xl_renderer}{list}(x, options)

\method{xl_renderer}{character}(x, options)
}
\arguments{
\item{x}{the object to be rendered in the XLSX file.}

\item{options}{the \code{knitr} and \code{knitxl} options used to cutomize the
rendering of \code{x}}
}
\value{
A character singleton, a data vector, or a data frame with class
\verb{knitxl_output_*} (either \code{text}, \code{vector} or \code{data_frame}, respectively).
}
\description{
This is a generic function that is intended for developers who want
to extend \code{knitxl} to print new classes R objects. It transforms an object
into a \verb{knitxl_output_*} class (either \code{text}, \code{vector} or \code{data_frame})
that can be printed in an XLSX file.
}
\examples{
   # Writes the summary of linear model fits a print output:
   xl_renderer.lm <- function(x, options) {
     res <- capture.output(summary(x))
     res <- paste0(res, collapse = "\n")
     class(res) <- "knit_xl_output_vector"
     res
   }
   registerS3method("xl_renderer", "lm", xl_renderer.lm)
   # knitxl will now print the summary of `lm` object in the generated
   # .xlsx file.

   # This will instead write the summary information about the coefficients
   # in a table:
   xl_renderer.lm <- function(x, options) {
     summary(x)$coefficients \%>\%
     as.data.frame() \%>\%
     new_knitxl_output_data_frame()
   }
  registerS3method("xl_renderer", "lm", xl_renderer.lm)

}
