% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_mats.R
\name{SwMatrixCalc}
\alias{SwMatrixCalc}
\title{Calculate Weighted Similarity Matrix}
\usage{
SwMatrixCalc(
  t.in,
  p.in,
  nPeriods.in,
  X.in,
  XdistMetric.in = "euclidean",
  weights = c(1/3, 1/3, 1/3)
)
}
\arguments{
\item{t.in}{numeric vector of time orders for points in the response series.}

\item{p.in}{numeric vector of period within a seasonal cycle (ex. 1 for January points in monthly data).}

\item{nPeriods.in}{numeric scalar indicating the maximum value \code{p.in} could take on (ex. 12 for monthly data).}

\item{X.in}{numeric vector or matrix of exogenous predictors, where the rows correspond to points in the response series.}

\item{XdistMetric.in}{character describing the method \code{stats::dist()} should use. This must be one of \code{"euclidean"},
\code{"maximum"}, \code{"manhattan"}, \code{"canberra"}, \code{"binary"}, or \code{"minkowski"}.}

\item{weights}{numeric vector where first value represents weight for \code{S_t}, second value the weight for \code{S_p}, and the third value the weight for \code{S_x}.}
}
\value{
numeric matrix of similarities which is calculated using \code{S_w}.
}
\description{
A wrapper function which calls each of \code{StMatrixCalc(v = t.in)},
\code{SpMatrixCalc(v = p.in, nPeriods = nPeriods.in)},
and \code{SxMatrixCalc(A = X.in, XdistMetric = XdistMetric.in)} to generate the three matrices of using the component measures of \code{S_w}. Then
generates the final weighted similarity matrix as the sum of each component matrix multiplied by its corresponding \code{weights}.
The first value in \code{weights} will be multiplied by \code{S_t}, the second \code{S_p}, and the third \code{S_x}.
}
\examples{
t <- c(1, 2, 3)
p <- c(1, 2, 1)
X <- matrix(c(1, 1, 1, 2, 2, 2, 3, 3, 3), nrow = 3, ncol = 3, byrow = TRUE)
SwMatrixCalc(
  t.in = t,
  p.in = p, nPeriods.in = 2,
  X.in = X,
  weights = c(1 / 4, 1 / 4, 1 / 2)
)
}
\seealso{
\itemize{
\item Trupiano (2021) arXiv:2112.06266 for information on the formulation of \code{S_w}.
\item \code{\link[=StMatrixCalc]{StMatrixCalc()}} for information on the calculation of \code{S_t}.
\item \code{\link[=SpMatrixCalc]{SpMatrixCalc()}} for information on the calculation of \code{S_p}.
\item \code{\link[=SxMatrixCalc]{SxMatrixCalc()}} for information on the calculation of \code{S_x}.
}
}
