% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tuning.R
\name{knn.forecast.randomsearch.tuning}
\alias{knn.forecast.randomsearch.tuning}
\title{Tune \code{knn.forecast()} Hyperparameters with Random Search}
\usage{
knn.forecast.randomsearch.tuning(
  grid.len = 100,
  St.in,
  Sp.in,
  Sx.in,
  y.in,
  test.h = 1,
  max.k = NULL,
  val.holdout.len = 0,
  min.k = 1
)
}
\arguments{
\item{grid.len}{integer value representing the number of hyperparameter sets to generate and test, must be \code{>= 1}.}

\item{St.in}{numeric and symmetric matrix of similarities, can be generated with \code{StMatrixCalc()}.}

\item{Sp.in}{numeric and symmetric matrix of similarities, can be generated with \code{SpMatrixCalc()}.}

\item{Sx.in}{numeric and symmetric matrix of similarities, can be generated with \code{SxMatrixCalc()}.}

\item{y.in}{numeric vector of the response series to be forecast.}

\item{test.h}{integer value representing the number of points in the test forecast horizon, must be \code{>= 1}.}

\item{max.k}{integer value representing the maximum value of k, \code{knn.forecast()} should use, will be set to \code{min(floor((length(y.in)) * .4), length(y.in) - val.holdout.len - test.h)} if \code{NULL} or \code{NA} is passed. Note this \code{NA} behavior differs from \code{knnwtsim} version 0.1.0.
If a numeric value is passed it must be \code{>= 1}.}

\item{val.holdout.len}{integer value representing the number of observations at the end of the series to be removed in testing forecast if desired to leave a validation set after tuning, must be \code{>= 0}.}

\item{min.k}{integer value representing the minimum value of k, \code{knn.forecast()} should use, must be \code{>= 1}.}
}
\value{
list of the following components:
\describe{
\item{weight.opt}{numeric vector of the 3 weights to generate \code{Sw.opt} in alpha, beta, gamma order which achieved the best performance in terms of MAPE.}
\item{k.opt}{integer value of neighbors used in \code{knn.forecast()} which achieved the best performance in terms of MAPE.}
\item{Sw.opt}{numeric matrix of similarities calculated using \code{S_w}, with the best performing set of hyperparameters.}
\item{Test.MAPE}{numeric value of the MAPE result for the optimum hyperparamter set achieved on the test points.}
\item{MAPE.all}{numeric vector of MAPE results, each observation corresponds to the row in \code{Grid} of the same index.}
\item{Grid}{dataframe of all hyperparameter sets tested in the tuning.}
}
}
\description{
A simplistic automated hyperparameter tuning function which randomly
generates a grid of hyperparameter sets used to build corresponding \code{S_w} similarity matrices
which are used in \code{knn.forecast()} test against the last \code{test.h} points of \code{y.in} after
any \code{val.holdout.len} points are removed from the end of \code{y.in}. The best performing set of
parameters based on MAPE over over the forecast horizon of \code{test.h} points are returned as part of a list
alongside the 'optimum' weighted similarity matrix \code{Sw.opt}, the \code{Grid} of tested sets, and the MAPE
results. MAPE is the average of absolute percent errors for each point calculated as: \code{abs((test.actuals - test.forecast.i) / test.actuals) * 100}. Where \code{test.forecast.i}
and \code{test.actuals} are both numeric vectors.
}
\examples{
data("simulation_master_list")
series.index <- 15
ex.series <- simulation_master_list[[series.index]]$series.lin.coef.chng.x

df <- data.frame(ex.series)
# Generate vector of time orders
df$t <- c(1:nrow(df))
# Generate vector of periods
nperiods <- simulation_master_list[[series.index]]$seasonal.periods
df$p <- rep(1:nperiods, length.out = nrow(df))
# Pull corresponding exogenous predictor(s)
X <- as.matrix(simulation_master_list[[series.index]]$x.chng)

St.ex <- StMatrixCalc(df$t)
Sp.ex <- SpMatrixCalc(df$p, nPeriods = nperiods)
Sx.ex <- SxMatrixCalc(X)

tuning.test <- knn.forecast.randomsearch.tuning(
  grid.len = 10,
  y.in = ex.series,
  St.in = St.ex,
  Sp.in = Sp.ex,
  Sx.in = Sx.ex,
  test.h = 3,
  max.k = 10,
  val.holdout.len = 3
)
}
\seealso{
\itemize{
\item Trupiano (2021) arXiv:2112.06266 for information on the formulation of \code{S_w}.
\item \code{\link[=StMatrixCalc]{StMatrixCalc()}} for information on the calculation of \code{S_t}.
\item \code{\link[=SpMatrixCalc]{SpMatrixCalc()}} for information on the calculation of \code{S_p}.
\item \code{\link[=SxMatrixCalc]{SxMatrixCalc()}} for information on the calculation of \code{S_x}.
\item \code{\link[=knn.forecast]{knn.forecast()}} for the function called to perform knn regression.
}
}
