% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{kdens_smlnorm}
\alias{kdens_smlnorm}
\title{Symmetric matrix log-normal kernel density}
\usage{
kdens_smlnorm(x, xs, b, log = TRUE)
}
\arguments{
\item{x}{cube of size \code{d} by \code{d} by \code{n} of points at which to evaluate the density}

\item{xs}{cube of size \code{d} by \code{d} by \code{m} of sample matrices which are used to construct the kernel}

\item{b}{positive double giving the bandwidth parameter}

\item{log}{bool; if \code{TRUE}, return the log density}
}
\value{
a vector of length \code{n} containing the (log) density of the sample \code{x}
}
\description{
Given a sample of \code{m} points \code{xs} from an original sample
and a set of \code{n} new sample matrices \code{x} at which to evaluate the symmetric matrix normal log kernel, return the density with bandwidth parameter \code{b}.
}
