% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ksrlive.R
\name{KSR.list}
\alias{KSR.list}
\title{Create a kinase substrate relationship list from a data frame}
\usage{
KSR.list(df, kinasefamilies = NULL, exclusive = FALSE)
}
\arguments{
\item{df}{data frame of kinase substrate relationships with substrate 
identifier in the first column and kinase identifier in the second column.}

\item{kinasefamilies}{named list of kinase identifiers that have to be combined, 
one list per kinase family, list will be named after first family member}

\item{exclusive}{logical, if TRUE only substrates exclusive to the kinase
will be included in the list (substrates with multiple kinases will be excluded)}
}
\value{
named list of substrate identifiers, with the corresponding kinase
identifiers as the list names

}
\description{
\code{KSR.list} returns a list of kinase substrate relationships
}
\details{
The function KSR.list creates a list of kinase substrate relationships from
a data frame and can combine kinase families into one list. Substrates occuring 
in multiple lists can be excluded.
}
\examples{
data(phosphonetworkdf)
data(datakin)

# first column has to be substrate id, second kinase id
kin_data <- KSR.list(phosphonetwork_df[, c("SUB_IDENT", "KIN_ACC_ID")]) 
# Akt1 and Akt2 belong to the same kinase family, combine their substrates 
# into one list and name the list after the first family member
fam <- list(akt = c("P31749", "P31751"))
kin_data_fam <- KSR.list(phosphonetwork_df[, c("SUB_IDENT", "KIN_ACC_ID")], 
kinasefamilies = fam)

# only include phosphosites appearing once
kin_data_fam_exc <- KSR.list(phosphonetwork_df[, c("SUB_IDENT", "KIN_ACC_ID")], 
                             kinasefamilies = fam,
                             exclusive = TRUE)
}

