% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kuzu_load_data.R
\name{kuzu_copy_from_csv}
\alias{kuzu_copy_from_csv}
\title{Load Data from a CSV File into a Kuzu Table}
\usage{
kuzu_copy_from_csv(conn, file_path, table_name, optional_csv_parameter = NULL)
}
\arguments{
\item{conn}{A Kuzu connection object.}

\item{file_path}{A string specifying the path to the CSV file.}

\item{table_name}{A string specifying the name of the destination table in
Kuzu.}

\item{optional_csv_parameter}{An optional parameter for CSV-specific
configurations (e.g., delimiter, header).
Refer to Kuzu documentation for available options.}
}
\value{
This function is called for its side effect of loading data and does
not return a value.
}
\description{
Loads data from a CSV file into a specified table in the Kuzu database.
}
\examples{
\donttest{
  conn <- kuzu_connection(":memory:")
  kuzu_execute(conn, "CREATE NODE TABLE City(name STRING, population INT64, 
  PRIMARY KEY (name))")

  # Create a temporary CSV file
  csv_file <- tempfile(fileext = ".csv")
  write.csv(data.frame(name = c("Berlin", "London"), 
  population = c(3645000, 8982000)),
            csv_file, row.names = FALSE)

  # Load data from CSV
  kuzu_copy_from_csv(conn, csv_file, "City")

  # Verify the data
  result <- kuzu_execute(conn, "MATCH (c:City) RETURN c.name, c.population")
  print(as.data.frame(result))

  # Clean up the temporary file
  unlink(csv_file)
}
}
\seealso{
\href{https://kuzudb.github.io/docs/import/csv/}{Kuzu CSV Import}
}
