% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/certificate_participation.R
\name{create_participation_certificate}
\alias{create_participation_certificate}
\title{Create certificate of participation}
\usage{
create_participation_certificate(
  data = NULL,
  path = NULL,
  filename = NULL,
  language = c("English", "Spanish"),
  name.column = NULL,
  affiliation.column = "",
  comm.type.column = "",
  title.column = "",
  coauthor.column = "",
  date.column = "",
  email.column = NULL,
  email.info = NULL,
  type = "",
  event = "",
  freetext = "",
  signer = "",
  signer.role = "",
  signature.pic = NULL,
  lpic = NULL,
  rpic = NULL,
  keep.files = FALSE,
  template = NULL
)
}
\arguments{
\item{data}{A data frame containing participants' names and contributions.}

\item{path}{path Character. Path to folder where the PDF certificates will be saved.}

\item{filename}{Character. Filename of the pdf. If NULL, default is "Participation" for English, "Participacion" for Spanish".}

\item{language}{Character. Select 'English' or 'Spanish'.}

\item{name.column}{Character. Name of the column in \code{data} storing participants' name.}

\item{affiliation.column}{Character (optional). Name of the column in \code{data}
storing participants' affiliation}

\item{comm.type.column}{Character. Name of the column in \code{data} reporting
participation type (e.g. poster, oral communication, etc)}

\item{title.column}{Character. Name of the column in \code{data} storing the title of the
contribution.}

\item{coauthor.column}{Name of the column in \code{data} storing the names of the coauthors to the contribution.}

\item{date.column}{Character. Name of the column in \code{data} storing dates of
participation.}

\item{email.column}{Character. Name of the column in \code{data} storing attendees' email address
to automatically send them their certificates.}

\item{email.info}{Object created using \code{\link[=configure_email]{configure_email()}} function.}

\item{type}{Character (optional). Type of event (conference, workshop, seminar...)}

\item{event}{Character. Title of the event}

\item{freetext}{Character (optional). Free text to insert before the date.
Can include LaTeX commands (see examples).}

\item{signer}{Character. Person who signs the certificate}

\item{signer.role}{Character. Signer's role or position}

\item{signature.pic}{Character (optional) Path to a PNG image to appear in
the bottom, above signer's name.}

\item{lpic}{Character (optional) Path to a PNG image to appear in the top-left.}

\item{rpic}{Character (optional) Path to a PNG image to appear in the top-right.}

\item{keep.files}{Logical. Keep the RMarkdown template and associated files
in the output folder? Default is FALSE.}

\item{template}{Character (optional) RMarkdown template to use. If not provided,
using the default template included in \code{labeleR}.}
}
\value{
PDF certificates are saved on disk, in the folder defined
by \code{path}. If \code{keep.files = TRUE}, the RMarkdown template and PNG logo files
will also appear in the same folder.
}
\description{
Create certificate of participation  (1 certificate per DIN-A4 page)
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
create_participation_certificate(
  data = participation.table,
  path = "labeleR_output",
  language = "Spanish",
  name.column = "Name",
  affiliation.column = "House",
  comm.type.column = "Comm.type",
  title.column = "Title",
  date.column = "Date",
  type = "online seminar",
  event = "Hogwarts School of Witchcraft and Wizardry",
  freetext = "which lasted 2 hours",
  signer = "A.P.W.B. Dumbledore",
  signer.role = "School Headmaster",
  lpic = NULL,
  rpic = NULL,
  signature.pic = NULL
)
\dontshow{\}) # examplesIf}
}
\author{
Ignacio Ramos-Gutierrez, Julia G. de Aledo, Francisco Rodriguez-Sanchez
}
