% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lama_translate_all.R
\name{check_and_translate_all}
\alias{check_and_translate_all}
\title{Check and translate function used by \code{lama_translate_all()} and \code{lama_to_factor_all()}}
\usage{
check_and_translate_all(.data, dictionary, prefix, suffix, fn_colname,
  keep_order, to_factor, is_translated, err_handler)
}
\arguments{
\item{.data}{Either a data frame, a factor or a vector.}

\item{dictionary}{A \link[=new_lama_dictionary]{lama_dictionary} object,
holding the translations for various variables.}

\item{prefix}{A character string, which is used as prefix for the new
column names.}

\item{suffix}{A character string, which is used as suffix for the new
column names.}

\item{fn_colname}{A function, which transforms character string into a new
character string. This function will be used to transform the old column
names into new column names under which the labeled variables will then
be stored.}

\item{keep_order}{A logical of length one, defining if the original order
(factor order or alphanumerical order) of the data frame variables should
be preserved.}

\item{to_factor}{A logical of length one, defining if the resulting labeled
variables should be factor variables (\code{to_factor = TRUE}) or plain
character vectors (\code{to_factor = FALSE}).}

\item{is_translated}{A boolean vector of length one or the same length as the
number of translations. If the vector has length one, then the same
configuration is applied to all variable translations.
If \code{is_translated = TRUE}, then the original variable is a character
vector holding the right labels (character strings).
In this case, the labels are left unchanged, but the variables are turned
into factors with order given in the selected translations.}

\item{err_handler}{An error handling function}
}
\description{
Check and translate function used by \code{lama_translate_all()} and \code{lama_to_factor_all()}
}
