% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lama_dictionary.R
\name{new_lama_dictionary}
\alias{new_lama_dictionary}
\alias{new_lama_dictionary.list}
\alias{new_lama_dictionary.character}
\alias{new_lama_dictionary.default}
\title{Create a new lama_dictionary class object}
\usage{
new_lama_dictionary(...)

\method{new_lama_dictionary}{list}(.data = NULL, ...)

\method{new_lama_dictionary}{character}(...)

\method{new_lama_dictionary}{default}(...)
}
\arguments{
\item{...}{None, one or more named/unnamed arguments. Depending on the type of
the type of the first argument passed into \code{new_lama_dictionary},
there are different valid ways of using \code{new_lama_dictionary}:
\itemize{
\item \emph{No arguments} were passed into \code{...}: In this case \code{new_lama_dictionary}
returns an empty lama_dictionary class object (e.g. \code{dict <- new_lama_dictionary()}).
\item \emph{The first argument is a list}: In this case, only the first argument of
\code{new_lama_dictionary} is used and it is allowed to use an unnamed argument call.
Furthermore, the passed in object must be a named list object, which contains all
translations that should be added to the new lama_dictionary class object.
Each item of the named list object must be a named character vector defining a translation
(e.g. \code{new_lama_dictionary(list(area = c("0" = "urban", "1" = "rural"),  = c(l = "Low", h = "High")))}
generates a lama_dictionary class object holding the translations \code{"area"} and \code{"density"}).
\item \emph{The first argument is a character vector}: In this case, it is allowed to pass in
more than one argument, but all given arguments when calling \code{new_directory}
must be \emph{named arguments} and each argument must be
a named character vectors defining translations
(e.g. \code{new_lama_dictionary(area = c("0" = "urban", "1" = "rural"), density = c(l = "Low", h = "High"))}
generates a lama_dictionary class object holding the translations \code{"area"} and \code{"density"}).
The names of the caller arguments will be used as names under which the given translations
will be added to the new lama_dictionary class object.
}}

\item{.data}{A named list object, where each list entry corresponds to a
translation that should be added to the lama_dictionary object
(e.g. \code{new_lama_dictionary(list(area = c("0" = "urban", "1" = "rural"),  = c(l = "Low", h = "High")))}
generates a lama_dictionary class object holding the translations \code{"area"} and \code{"density"}).
The names of the list entries are the names under which the translation
will be added to the new lama_dictionary class object (e.g. \code{area} and \code{density}).
Each list entry must be a named character vector defining a translation
(e.g. \code{c("0" = "urban", "1" = "rural")} is the translation with
the name \code{area} and \code{c(l = "Low", h = "High")} is the translation
with the name \code{density}).}
}
\value{
A new lama_dictionary class object holding the passed in translations.
}
\description{
Generates an \emph{S3} class object, which holds the \emph{variable translations}.
There are three valid ways to use \code{new_lama_dictionary} in order to create a
\code{lama_dictionary} class object:
\itemize{
\item \emph{No arguments} were passed into \code{...}: In this case \code{new_lama_dictionary}
returns an empty lama_dictionary class object (e.g. \code{dict <- new_lama_dictionary()}).
\item \emph{The first argument is a list}: In this case only the first argument of
\code{new_lama_dictionary} is used. It is not necessary to pass in a named argument.
The passed in object must be a \emph{named list object}, which contains all
translations that should be added to the new lama_dictionary class object.
Each item of the named list object must be a \emph{named character vector} defining a translation
(e.g. \code{new_lama_dictionary(list(area = c("0" = "urban", "1" = "rural"),  = c(l = "Low", h = "High")))}
generates a lama_dictionary class object holding the translations \code{"area"} and \code{"density"}).
\item \emph{The first argument is a character vector}: In this case, it is allowed to pass in
\emph{more than one argument}. In this case, all given arguments must be \emph{named arguments}
holding \emph{named character vectors} defining translations
(e.g. \code{new_lama_dictionary(area = c("0" = "urban", "1" = "rural"), density = c(l = "Low", h = "High"))}
generates a lama_dictionary class object holding the translations \code{"area"} and \code{"density"}).
The names of the passed in arguments will be used as the names,
under which the given translations
will be added to the new lama_dictionary class object.
}
}
\section{Translations}{

A \emph{translation} is a \emph{named character vector} of non zero length.
This named character vector defines
which labels (of type character) should be assigned to which values
(can be of type character, logical or numeric)
(e.g. the translation \code{c("0" = "urban", "1" = "rural")} assigns the label
\code{"urban"} to the value \code{0} and \code{"rural"} to the value \code{1}, for example the
variable \code{x = c(0, 0, 1)} is translated to \code{x_new = c("urban", "urban", "rural")}).
Therefore, a translation (named character vector) contains the following information:
\itemize{
\item The \emph{names} of the character vector entries correspond to the
\emph{original variable levels}.
Variables of types \code{numeric} or \code{logical} are turned automatically into a
character vector (e.g. \code{0} and \code{1} are treated like \code{"0"} and \code{"1"}).
\item The \emph{entries} (character strings) of the character vector correspond to
the new \emph{labels}, which will be assigned to the original variable levels.
It is also allowed to have missing labels (\code{NA}s).
In this case, the original values are mapped onto missing values.
}

The function \code{\link[=lama_translate]{lama_translate()}} is used in order to apply a translation on a variable.
The resulting vector with the assigned labels can be of the following types:
\itemize{
\item \emph{character}: An unordered vector holding the new character labels.
\item \emph{factor} with character levels: An ordered vector holding the new character labels.
}

The original variable can be of the following types:
\itemize{
\item \emph{character} vector: This is the simplest case. The character values
will replaced by the corresponding labels.
\item \emph{numeric} or \emph{logical} vector: Vectors of type \emph{numeric} or \emph{logical}
will be turned
into \emph{character} vectors automatically before the translation process and
then simply processed like in the \emph{character} case.
Therefore, it is sufficient to define the translation mapping for the
\emph{character} case, since it also covers the \emph{numeric} and \emph{logical} case.
\item \emph{factor} vector with levels of any type: When translating factor variables
one can decide whether or not to keep the original ordering. Like in the
other cases the levels of the factor variable will always be turned into
character strings before the translation process.
}
}

\section{Missing values}{

It is also possible to handle missing values with \code{\link[=lama_translate]{lama_translate()}}.
Therefore, the used translation must contain a information that tells how
to handle a missing value. In order to define such a translation
the missing value (\code{NA}) can be escaped with the character string \code{"NA_"}.
This can be useful in two situations:
\itemize{
\item All missing values should be labeled
(e.g. the translation \code{c("0" = "urban", "1" = "rural", NA_ = "missing")}
assigns the character string \code{"missing"} to all missing values of a variable).
\item Map some original values to \code{NA}
(e.g. the translation \code{c("0" = "urban", "1" = "rural", "2" = "NA_", "3" = "NA_")}
assigns \code{NA} (the missing character) to the original values \code{2} and \code{3}).
Actually, in this case the translation definition does not always have to
use this escape mechanism, but only
when defining the translations inside of a \code{YAML} file,
since the \code{YAML} parser does not recognize missing values.
}
}

\section{lama_dictionary class objects}{

Each \emph{lama_dictionary} class object can contain multiple \emph{translations},
each with a unique name under which the translation can be found.
The function \code{\link[=lama_translate]{lama_translate()}} uses a lama_dictionary class object
to translate a normal \code{vector} or to translate one or more columns in a
\code{data.frame}.
Sometimes it may be necessary to have different translations
for the same variable, in this case it is best to have multiple
translations with different names
(e.g. \code{area_short = c("0" = "urb", "1" = "rur")} and
\code{area = c("0" = "urban", "1" = "rural")}).
}

\examples{
  ## Example-1: Initialize a lama-dictionary from a list object
  ##            holding the translations
  dict <- new_lama_dictionary(list(
    country = c(uk = "United Kingdom", fr = "France", NA_ = "other countries"),
    language = c(en = "English", fr = "French")
  ))
  dict

  ## Example-2: Initialize the lama-dictionary directly
  ##            by assigning each translation to a name
  dict <- new_lama_dictionary(
    country = c(uk = "United Kingdom", fr = "France", NA_ = "other countries"),
    language = c(en = "English", fr = "French")
  )
  dict
  
}
\seealso{
\code{\link[=is.lama_dictionary]{is.lama_dictionary()}}, \code{\link[=as.lama_dictionary]{as.lama_dictionary()}}, \code{\link[=lama_translate]{lama_translate()}},
\code{\link[=lama_to_factor]{lama_to_factor()}}, \code{\link[=lama_translate_all]{lama_translate_all()}}, \code{\link[=lama_to_factor_all]{lama_to_factor_all()}},
\code{\link[=lama_read]{lama_read()}}, \code{\link[=lama_write]{lama_write()}},
\code{\link[=lama_select]{lama_select()}}, \code{\link[=lama_rename]{lama_rename()}}, \code{\link[=lama_mutate]{lama_mutate()}}, \code{\link[=lama_merge]{lama_merge()}}
}
