% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbrac.R
\name{sbrac}
\alias{sbrac}
\title{Safely Extract Elements of a Labeled Data Frame}
\usage{
sbrac(data, ri = NULL, ci = NULL, partial = FALSE)
}
\arguments{
\item{data}{the data.frame from which columns will be selected.}

\item{ri}{row indices (integer positional or logical) or row.names (or
partial row.names if partial = TRUE) to be selected.}

\item{ci}{column indices (integer positional or logical) or column / variable
names (or partial column names if partial = TRUE) to be selected.}

\item{partial}{if TRUE, any row or column that contains the relevant
character substring will be selected (e.g., sbrac(mtcars, c("Maz"), c("di"))
will return all "Mazda" car rows and the column "disp").}
}
\value{
a labelr label attribute-preserving data.frame, consisting of the
selected rows and/or columns index-selected.
}
\description{
\code{sbrac} allows one to do "bracket-like" row and/or column selection
(without actual brackets) on a labelr-labeled data.frame in a manner that
preserves its labelr label attributes.
}
\details{
\code{sbrac} allows one to select rows and columns of a data.frame in a bracket-
like fashion, using integers (positional indices), logicals, or (partial)
character names (row names and column/variable names). For example,
sbrac(df, 1:5, 2:4) returns a data.frame (with any labelr attribute
meta-data intact), consisting of rows 1-5 and columns 2-4 of data.frame df;
while sbrac(mtcars, "Maz", "a", partial = TRUE) returns all variables with
substring "a" in their names for all rows with substring "Maz" in their row
names. Integer indices (only) can be enclosed in -c() for negative index
selection (i.e., "select not these"), where, e.g.,
sbrac(df, -c(1,2), "x", partial = TRUE) means select all rows of df other
than rows 1 and 2 and all columns that feature the letter "x" in their names.
See also \code{ssubset}, \code{sfilter}, \code{sselect}, \code{sdrop}, \code{ssort}, and \code{srename}, as
well as \code{slab} and \code{flab} for other labelr attribute-preserving subsetting
tools.
}
\examples{
# create a copy of the mtcars data set
mtc2 <- mtcars

# variable names and their labels
names_labs_vec <- c(
  "mpg" = "Miles/(US) gallon",
  "cyl" = "Number of cylinders",
  "disp" = "Displacement (cu.in.)",
  "hp" = "Gross horsepower",
  "drat" = "Rear axle ratio",
  "wt" = "Weight (1000 lbs)",
  "qsec" = "1/4 mile time",
  "vs" = "Engine (0 = V-shaped, 1 = straight)",
  "am" = "Transmission (0 = automatic, 1 = manual)",
  "gear" = "Number of forward gears",
  "carb" = "Number of carburetors"
)

# assign variable labels
mtc2 <- add_name_labs(mtc2,
  vars = names(names_labs_vec),
  labs = names_labs_vec
)

# examples of sbrac() functionality
sbrac(mtc2, 1:4, ) # commas used in a bracket-like way: row 1:4 and all cols
sbrac(mtc2, , 1:4) # commas used in a bracket-like way: all rows and cols 1:4
sbrac(mtc2, 1, 2) # 1 is row, 2 is col
sbrac(mtc2, -c(8:32), -c(1:8)) # select NOT-these rows and cols (-)
sbrac(mtc2, 1:5, 1:2) # rows 1-5, cols 1 and 2

# if partial = TRUE, partial matching to get all Mazda or Merc + all
# ...vars with "ar" in name
sbrac(mtc2, c("Mazda", "Merc"), c("ar"), partial = TRUE) # see what this does
mtc3 <- sbrac(mtc2, c("45"), 1:2, partial = TRUE) # see what this does
get_labs_att(mtc3, "name.labs") # name.labs still there
}
