% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curve.R
\name{lactate_curve}
\alias{lactate_curve}
\title{Lactate curve}
\usage{
lactate_curve(
  .data,
  intensity_column,
  lactate_column,
  heart_rate_column,
  fit = c("3rd degree polynomial", "4th degree polynomial", "B-spline"),
  include_baseline = FALSE,
  sport = c("cycling", "running", "swimming")
)
}
\arguments{
\item{.data}{The raw data.}

\item{intensity_column}{The name of the intensity column.}

\item{lactate_column}{The name of the lactate column.}

\item{heart_rate_column}{The name of the heart rate column, if applicable.}

\item{fit}{The fit you would like to use for plotting the lactate curve.
Options are \verb{3rd degree polynomial}, \verb{4th degree polynomial}, or \code{B-spline}.}

\item{include_baseline}{A boolean to indicate whether to include the baseline value in the fit.}

\item{sport}{The sport at which the incremental test was performed. One of \code{cycling}, \code{running}, or \code{swimming}.}
}
\value{
a list with the following elements:
\item{data}{a tibble containing the raw data with the columns \code{intensity}, \code{lactate}, and \code{heart_rate}.}
\item{lactate_curve}{a tibble containing the data with the columns \code{intensity} and \code{lactate} for plotting the lactate curve according to the \code{fit} method chosen.}
\item{heart_rate_response}{a tibble containing the data with the columns \code{intensity} and \code{heart_rate} for plotting the heart rate response using the linear method.}
}
\description{
It retrieves the lactate curve for plotting purposes.
}
\examples{
\dontrun{
lactate_curve(
  .data = demo_data,
  intensity_column = "intensity",
  lactate_column = "lactate",
  heart_rate_column = "heart_rate",
  fit = "3rd degree polynomial",
  include_baseline = TRUE,
  sport = "cycling"
)
}
}
