% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lakeMeanDepth.R
\name{lakeMeanDepth}
\alias{lakeMeanDepth}
\title{Function to return lake Mean Depth}
\usage{
lakeMeanDepth(inLakeMorpho, zmax = NULL, slope_quant = 0.5, correctFactor = 1)
}
\arguments{
\item{inLakeMorpho}{An object of \code{\link{lakeMorphoClass}}.  Output of the 
\code{\link{lakeSurroundTopo}} function would be appropriate as input}

\item{zmax}{Maximum depth of the lake.  If none entered and elevation dataset
is inlcuded in inLakeMorpho, \code{\link{lakeMaxDepth}} is used 
to estimate a maximum depth.}

\item{slope_quant}{The slope quantile to use to estimate maximum depth.
Defaults to the median as described in (Hollister et. al, 
2011).}

\item{correctFactor}{This a factor used by \code{\link{lakeMaxDepth}} to
correct the predicted maximum lake depth.  Defaults to 1.}
}
\value{
Returns a numerica value for the mean depth of the lake
}
\description{
Calculates average depth of lake as a mean of lake volume divided by
lake surface area
}
\examples{
data(lakes)
lakeMeanDepth(inputLM)
}
\references{
Florida LAKEWATCH (2001). A Beginner's guide to water management
            - Lake Morphometry (2nd ed.). Gainesville: Florida LAKEWATCH, 
            Department of Fisheries and Aquatic Sciences.
            \href{http://edis.ifas.ufl.edu/pdffiles/FA/FA08100.pdf}{Link}
}
