% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmm.fixed.R
\name{Intercept-ergmTerm}
\alias{Intercept-ergmTerm}
\alias{InitErgmTerm.Intercept}
\alias{1-ergmTerm}
\alias{intercept-ergmTerm}
\title{Intercept}
\usage{
# binary: 1(mean=0, var=9)

# binary: Intercept(mean=0, var=9)

# binary: intercept(mean=0, var=9)

# valued: 1(mean=0, var=9)

# valued: Intercept(mean=0, var=9)

# valued: intercept(mean=0, var=9)
}
\arguments{
\item{mean, var}{prior mean and variance.}
}
\description{
This term serves as an intercept term, is included by
default (though, as in \code{\link{lm}}, it can be excluded by
adding \code{+0} or \code{-1} into the model formula). It adds
one covariate to the model, for which \code{x[i,j]=1} for all
\code{i} and \code{j}.

It can be used explicitly to set prior mean and variance for the
intercept term.

\strong{Important:} This term works in \CRANpkg{latentnet}'s \code{\link[=ergmm]{ergmm()}} only. Using it in \code{\link[ergm:ergm]{ergm()}} will result in an error.
}
\seealso{
\code{\link[ergm:ergmTerm]{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "Intercept", "subsection")}
}
\concept{directed}
\concept{dyad-independent}
\concept{latent}
\concept{undirected}
