% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.densityOut.R
\name{plot.densityOut}
\alias{plot.densityOut}
\title{Plot the density map}
\usage{
\method{plot}{densityOut}(x, ...)
}
\arguments{
\item{x}{An object of type densityOut returned by createDensity.}

\item{\dots}{Graphical parameters for the function contour.default.}
}
\value{
No return value, called for side effects
}
\description{
Plots the boundary, all holes and the locations of 
all nodes along with the density contour map.
}
\examples{
plot.new()
data(polygon1)
#
nodeFillingOutput <- nodeFilling(poly=polygon1, node_spacing=0.025)
plot(nodeFillingOutput)
formLatticeOutput <- formLattice(nodeFillingOutput)
plot(formLatticeOutput)
#
Pointdata <- splancs::csr(polygon1,75)
Pointdata <- Pointdata[Pointdata[,1]<0.5,]
plot(polygon1,type="n")
polygon(polygon1)
points(Pointdata,pch=19)
#
densityOut <- createDensity(formLatticeOutput,PointPattern=Pointdata,
                           k=55,intensity=FALSE, sparse = TRUE)
plot(densityOut)
#
homerange(densityOut, percent = 0.95)

}
\references{
Ronald P. Barry, Julie McIntyre. Estimating 
animal densities and home range in regions with irregular 
boundaries and holes: A lattice-based alternative to the 
kernel density estimator. Ecological Modelling 222 (2011) 
1666-1672
}
\author{
Ronald P. Barry
}
