% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_plot.R
\name{item_plot}
\alias{item_plot}
\title{Plot model-implied vs empirical item curves by latent factor (single- or multi-group)}
\usage{
item_plot(
  x,
  latent,
  items = NULL,
  show_model = TRUE,
  show_empirical = TRUE,
  show_points = TRUE,
  show_metrics = TRUE,
  metrics_pad = 0.05,
  point_size = 1.2,
  line_width = 0.9,
  color_points = "black",
  color_model = "blue",
  color_empirical = "red",
  alpha_points = 0.05,
  alpha_ribbon = 0.2,
  jitter_sd = 0.05,
  jitter_seed = NULL,
  sample_frac = 1,
  point_shape = 16,
  ribbons = TRUE,
  penalized = FALSE,
  facet = c("wrap", "grid"),
  ncol = NULL,
  nrow = NULL,
  scales = c("fixed", "free_y", "free", "free_x"),
  sort = c("none", "r2", "r2_pen", "rmse", "rmse_pen", "mae", "mae_pen"),
  sort_dir = c("auto", "asc", "desc")
)
}
\arguments{
\item{x}{A list returned by \code{item_data()}.}

\item{latent}{Character scalar: latent factor ID shown on x-axis.}

\item{items}{Optional character vector of item names to include; inferred if \code{NULL}.}

\item{show_model, show_empirical, show_points}{Logical toggles to draw the model curve,
the empirical curve, and raw datapoints (all \code{TRUE} by default).}

\item{show_metrics}{Logical: print per-item fit metrics inside each facet (default \code{TRUE}).}

\item{metrics_pad}{Additional top padding for facets when \code{show_metrics = TRUE}.
Controls the gap between metric labels and the plotting area (default \code{0.05}).}

\item{point_size}{Numeric size of points (defaults chosen for legibility).}

\item{line_width}{Numeric linewidth for model/empirical curves (defaults chosen for legibility).}

\item{color_points, color_model, color_empirical}{Colors for points, model curve/ribbon, empirical curve/ribbon
(defaults chosen for legibility).}

\item{alpha_points, alpha_ribbon}{Alphas for points and ribbons (defaults chosen for legibility).}

\item{jitter_sd}{Vertical jitter SD (on the data scale); normally distributed.
The applied jitter is truncated to ±3·SD to avoid extreme outliers.}

\item{jitter_seed}{Optional integer seed for deterministic vertical jitter.}

\item{sample_frac}{Optional fraction in (0,1] to thin raw datapoints before plotting (default 1 = no thinning).}

\item{point_shape}{Integer/character ggplot2 shape for points (choose a fast filled shape, default 16).}

\item{ribbons}{Logical: draw CI ribbons when available (default \code{TRUE}).}

\item{penalized}{Logical: use penalized metrics in facet captions (default \code{FALSE}).}

\item{facet}{One of \code{"wrap"}, \code{"grid"}. Multi-group inputs always use grid.}

\item{ncol, nrow}{Optional layout hints used when \code{facet = "wrap"}.}

\item{scales}{Facet scales (passed to ggplot2 facets). Default \code{"fixed"}.}

\item{sort}{Item ordering by a metric; one of \code{"none"}, \code{"r2"}, \code{"r2_pen"},
\code{"rmse"}, \code{"rmse_pen"}, \code{"mae"}, \code{"mae_pen"} (default \code{"none"}). For multi-group,
the metric is averaged across groups.}

\item{sort_dir}{Direction of sort if \code{sort != "none"}; one of \code{"auto"},
\code{"asc"}, \code{"desc"}. \code{auto} sorts R²-like metrics descending and error metrics ascending.}
}
\value{
A \code{ggplot2} object (single-group) or a faceted \code{ggplot2} object (multi-group).
The plot is returned (and printed if not assigned) and can be further modified with \code{+}.
}
\description{
Given the output list of \code{item_data()}, draw smooth curves of the
model-implied relation and the empirical GAM-based relation between a chosen
latent factor (x-axis) and all items that load on it (y-axis). Works for
continuous, ordinal, and mixed models; supports single- and multi-group fits.
}
\examples{
\donttest{
HS.model <- '
  visual  =~ x1 + x2 + x3
  textual =~ x4 + x5 + x6
  speed   =~ x7 + x8 + x9
'
fit <- lavaan::cfa(HS.model,
                   data = lavaan::HolzingerSwineford1939,
                   meanstructure = TRUE)
idata <- item_data(fit)
item_plot(idata, latent = 'visual')

# Multi-group example (facet grid, sort by R2)
fit_mg <- lavaan::cfa(HS.model,
                      data = lavaan::HolzingerSwineford1939,
                      group = 'school', meanstructure = TRUE)
idata_mg <- item_data(fit_mg)
item_plot(idata_mg, latent = 'visual', facet = 'grid', sort = 'r2')
}

}
\seealso{
\link{item_data}, \link{augment}, \link{prepare}

Other lavDiag-visualization: 
\code{\link{hopper_plot}()}
}
\concept{lavDiag-visualization}
