% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool-residuals.R
\name{lavResiduals.mi}
\alias{lavResiduals.mi}
\alias{residuals,lavaan.mi-method}
\alias{resid,lavaan.mi-method}
\title{Covariance and Correlation Residuals}
\usage{
\S4method{residuals}{lavaan.mi}(object, type = "raw", omit.imps = c("no.conv", "no.se"), ...)

\S4method{resid}{lavaan.mi}(object, type = "raw", omit.imps = c("no.conv", "no.se"), ...)

lavResiduals.mi(object, omit.imps = c("no.conv", "no.se"), ...)
}
\arguments{
\item{object}{An object of class \code{lavaan.mi}}

\item{type}{\code{character} indicating whether/how to standardize the covariance
residuals. If \code{type = "raw"}, the raw (= unscaled) difference between
the observed and expected (model-implied) summary statistics are
returned. The observed summary statistics are averaged across
imputations, and the model-implied statistics are calculated from
pooled parameter estimates (as returned by \code{fitted.values()}).
If \code{type = "cor"} or \code{"cor.bollen"}, the observed and
model-implied covariance matrices are first transformed to
correlation matrices (using \code{\link[stats:cor]{stats::cov2cor()}}); then correlation
residuals are computed. If \code{type = "cor.bentler"}, both the observed
and model-implied covariance matrices are rescaled by dividing the
elements by the square roots of the corresponding variances of the
observed covariance matrix.}

\item{omit.imps}{\code{character} indicating criteria for excluding imputations
from pooled results. See \linkS4class{lavaan.mi} for argument details.}

\item{\dots}{Arguments passed to \code{\link[lavaan:lavResiduals]{lavaan::lavResiduals()}}.}
}
\value{
A \code{list} of residuals and other information (see \code{\link[lavaan:lavResiduals]{lavaan::lavResiduals()}}).
The standard \code{residuals()} (and \code{resid()} alias) method simply calls
\code{lavResiduals.mi(..., zstat=FALSE, summary=FALSE)}.
}
\description{
This function calculates residuals for sample moments (e.g., means and
(co)variances, means) from a lavaan model fitted to multiple imputed data
sets, along with summary and inferential statistics about the residuals.
}
\examples{

data(HS20imps) # import a list of 20 imputed data sets

## specify CFA model from lavaan's ?cfa help page
HS.model <- '
  visual  =~ x1 + x2 + x3
  textual =~ x4 + x5 + x6
  speed   =~ x7 + x8 + x9
'
## fit model to 20 imputed data sets
fit <- cfa.mi(HS.model, data = HS20imps)

## default type = "cor.bentler" (standardized covariance residuals)
lavResiduals.mi(fit, zstat = FALSE)
## SRMR is in the $summary

## correlation residuals
lavResiduals.mi(fit, zstat = FALSE, type = "cor")
## CRMR is in the $summary

## raw covariance residuals
lavResiduals.mi(fit, type = "raw") # zstat=TRUE by default
## RMR is in the $summary
## "normalized" residuals are in $cov.z


## The standard resid() and residuals() method simply call lavResiduals.mi()
## with arguments to display only the residuals ("raw" by default).
\donttest{
resid(fit)
residuals(fit, type = "cor.bollen") # same as type = "cor"
}

}
\seealso{
\code{\link[lavaan:lavResiduals]{lavaan::lavResiduals()}} for details about other arguments.
}
\author{
Terrence D. Jorgensen (University of Amsterdam;
\email{TJorgensen314@gmail.com})
}
