% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ltrend.test.R
\name{ltrend.test}
\alias{ltrend.test}
\title{Test for a Linear Trend in Variances}
\usage{
ltrend.test(
  y,
  group,
  score = NULL,
  location = c("median", "mean", "trim.mean"),
  tail = c("right", "left", "both"),
  trim.alpha = 0.25,
  bootstrap = FALSE,
  num.bootstrap = 1000,
  correction.method = c("none", "correction.factor", "zero.removal", "zero.correction"),
  correlation.method = c("pearson", "kendall", "spearman")
)
}
\arguments{
\item{y}{a numeric vector of data values.}

\item{group}{factor of the data.}

\item{score}{weights to be used in testing an increasing/decreasing trend in 
group variances, \code{score} coincides by default with \code{group}; 
it can be chosen as a linear, quadratic or any other monotone function.}

\item{location}{the default option is \code{"median"} corresponding to the
robust Brown--Forsythe Levene-type procedure \insertCite{Brown_Forsythe_1974}{lawstat}; 
\code{"mean"} corresponds to the classical Levene's procedure
\insertCite{Levene_1960}{lawstat}, and \code{"trim.mean"} corresponds to the robust
Levene-type procedure using the group trimmed means.}

\item{tail}{the default option is \code{"right"}, corresponding to an increasing
trend in variances as the one-sided alternative;  \code{"left"} corresponds to a
decreasing trend in variances, and  \code{"both"} corresponds to any
(increasing or decreasing) monotonic trend in variances as the two-sided alternative.}

\item{trim.alpha}{the fraction (0 to 0.5) of observations to be trimmed from
each end of \code{x} before the mean is computed.}

\item{bootstrap}{a logical value identifying whether to implement bootstrap.
The default is \code{FALSE}, i.e., no bootstrap; if set to \code{TRUE},
the bootstrap method described in \insertCite{Lim_Loh_1996;textual}{lawstat}
for Levene's test is applied.}

\item{num.bootstrap}{number of bootstrap samples to be drawn when the \code{bootstrap}
argument is set to \code{TRUE}. The default value is 1000.}

\item{correction.method}{procedures to make the test more robust;
the default option is \code{"none"}; \code{"correction.factor"} applies the
correction factor described by \insertCite{OBrien_1978;textual}{lawstat} and
\insertCite{Keyes_Levy_1997;textual}{lawstat}; \code{"zero.removal"} performs the
structural zero removal method by \insertCite{Hines_Hines_2000;textual}{lawstat};
\code{"zero.correction"} performs a combination of the O'Brien's correction factor
and the Hines--Hines structural zero removal method \insertCite{Noguchi_Gel_2010}{lawstat}.
Note that the options \code{"zero.removal"} and \code{"zero.correction"} are only
applicable when the location is set to \code{"median"}, otherwise, \code{"none"} is applied.}

\item{correlation.method}{measures of correlation; the default option is
\code{"pearson"}, the linear correlation coefficient that is equivalent to the t-test;
nonparametric measures of correlation such as \code{"kendall"} (Kendall's tau)
or \code{"spearman"} (Spearman's rho) may also be chosen.}
}
\value{
A list of class \code{"htest"} containing the following components:
\item{statistic}{the value of the test statistic expressed in terms of correlation 
(Pearson, Kendall, or Spearman).}
\item{p.value}{the \eqn{p}-value of the test.}
\item{method}{type of test performed.}
\item{data.name}{a character string giving the name of the data.}
\item{t.statistic}{the value of the test statistic from Student's t-test.}
\item{non.bootstrap.p.value}{the \eqn{p}-value of the test without bootstrap method.}
\item{log.p.value}{the log of the \eqn{p}-value}
\item{log.q.value}{the log of the (one minus the \eqn{p}-value).}
}
\description{
Test for a linear trend in variances.
}
\details{
The test statistic is based on 
the classical Levene's procedure (using the group means), 
the modified Brown--Forsythe Levene-type procedure (using the group medians),
or the modified Levene-type procedure (using the group trimmed means).
More robust versions of the test using the correction factor or structural zero
removal method are also available. Two options for calculating critical values,
namely, approximated and bootstrapped, are available.
By default, \code{NA}s are omitted from the data.
}
\examples{
data(pot)
ltrend.test(pot[, "obs"], pot[, "type"], location = "median", tail = "left", 
            correction.method = "zero.correction")

## Bootstrap version of the test. The calculation may take up a few minutes 
## depending on the number of bootstrap samples.
ltrend.test(pot[, "obs"], pot[, "type"], location = "median", tail = "left", 
             correction.method = "zero.correction", 
             bootstrap = TRUE, num.bootstrap = 500)
             
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{neuhauser.hothorn.test}}, \code{\link{levene.test}}, 
\code{\link{lnested.test}}, \code{\link{mma.test}}, \code{\link{robust.mmm.test}}
}
\author{
Kimihiro Noguchi, W. Wallace Hui, Yulia R. Gel, Joseph L. Gastwirth, Weiwen Miao
}
\keyword{htest}
\keyword{robust}
\keyword{variability}
